/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.commands;

import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.commands.CurrentWeatherSubcommand;
import eu.luftiger.syncedweather.commands.HelpSubcommand;
import eu.luftiger.syncedweather.commands.InfoSubcommand;
import eu.luftiger.syncedweather.commands.ReloadSubcommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class SyncedWeatherCommand
implements TabExecutor {
    private final SyncedWeather plugin;

    public SyncedWeatherCommand(SyncedWeather plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length >= 1) {
            switch (args[0].toLowerCase()) {
                case "info": {
                    new InfoSubcommand(this.plugin).execute(sender, args);
                    break;
                }
                case "currentweather": {
                    new CurrentWeatherSubcommand(this.plugin).execute(sender, args);
                    break;
                }
                case "reload": {
                    new ReloadSubcommand(this.plugin).execute(sender, args);
                    break;
                }
                case "help": {
                    new HelpSubcommand(this.plugin).execute(sender, args);
                }
            }
        } else {
            sender.sendMessage(this.plugin.getConfigService().getMessage("Messages.lenght_error", true));
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> finalCompletions = new ArrayList<String>();
        if (args.length <= 1) {
            Player player;
            completions.add("info");
            completions.add("currentWeather");
            completions.add("help");
            if (sender instanceof Player && (player = (Player)sender).hasPermission("syncedweather.reload")) {
                completions.add("reload");
            }
        }
        if (!args[args.length - 1].equals("")) {
            for (String completion : completions) {
                if (!completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                finalCompletions.add(completion);
            }
        } else {
            finalCompletions.addAll(completions);
        }
        return finalCompletions;
    }
}

