/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather.commands;

import eu.luftiger.syncedweather.SyncedWeather;
import eu.luftiger.syncedweather.model.Weather;
import eu.luftiger.syncedweather.utils.ConfigService;
import eu.luftiger.syncedweather.utils.WeatherService;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CurrentWeatherSubcommand {
    private final ConfigService configService;
    private final WeatherService weatherService;

    public CurrentWeatherSubcommand(SyncedWeather plugin) {
        this.configService = plugin.getConfigService();
        this.weatherService = plugin.getWeatherService();
    }

    public void execute(CommandSender sender, String[] args) {
        String unknown;
        Weather weather = this.weatherService.getWeather();
        List lines = this.configService.getConfig().getStringList("Messages.info_map.lines");
        String weatherName = unknown = this.configService.getMessage("Messages.info_map.unknown", false);
        String locationName = unknown;
        String temp = weather.getTempC() + "\u00b0C \u00a78/\u00a7r " + weather.getTempF() + "\u00b0F";
        if (weather.getWeatherName() != null) {
            weatherName = this.configService.getMessage("Messages.info_map.weathernames." + weather.getWeatherName().toLowerCase(), false);
        }
        if (weather.getLocationName() != null) {
            locationName = weather.getLocationName();
        }
        String compassDirection = unknown;
        if (weather.getWindDegree() <= 22.5 || weather.getWindDegree() >= 337.5) {
            compassDirection = "N";
        }
        if (weather.getWindDegree() >= 22.5 && weather.getWindDegree() <= 67.5) {
            compassDirection = "NO";
        }
        if (weather.getWindDegree() >= 67.5 && weather.getWindDegree() <= 112.5) {
            compassDirection = "O";
        }
        if (weather.getWindDegree() >= 112.5 && weather.getWindDegree() <= 157.5) {
            compassDirection = "SO";
        }
        if (weather.getWindDegree() >= 157.5 && weather.getWindDegree() <= 202.5) {
            compassDirection = "S";
        }
        if (weather.getWindDegree() >= 202.5 && weather.getWindDegree() <= 247.5) {
            compassDirection = "SW";
        }
        if (weather.getWindDegree() >= 247.5 && weather.getWindDegree() <= 292.5) {
            compassDirection = "W";
        }
        if (weather.getWindDegree() >= 292.5 && weather.getWindDegree() <= 337.5) {
            compassDirection = "NW";
        }
        String wind = weather.getWindSpeed() + "km/h\u00a78,\u00a7r " + compassDirection;
        for (String line : lines) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line).replace("{location}", locationName).replace("{temperature}", temp).replace("{weather}", weatherName).replace("{wind}", wind));
        }
    }
}

