/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.syncedweather;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import eu.luftiger.bukkit.Metrics;
import eu.luftiger.syncedweather.commands.SyncedWeatherCommand;
import eu.luftiger.syncedweather.listeners.PlayerJoinListener;
import eu.luftiger.syncedweather.scheduler.CheckUpTask;
import eu.luftiger.syncedweather.utils.ConfigService;
import eu.luftiger.syncedweather.utils.Placeholder;
import eu.luftiger.syncedweather.utils.ProtocolHandler;
import eu.luftiger.syncedweather.utils.UpdateCheckService;
import eu.luftiger.syncedweather.utils.WeatherService;
import java.util.Objects;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class SyncedWeather
extends JavaPlugin {
    private final Logger logger = this.getLogger();
    private WeatherService weatherService;
    private ConfigService configService;
    private CheckUpTask checkUpTask;
    private ProtocolManager protocolManager;
    private ProtocolHandler protocolHandler;
    private boolean isNewerVersion;

    public void onEnable() {
        this.logger.info("enabling plugin...");
        this.logger.info("loading config...");
        this.configService = new ConfigService(this);
        this.configService.createDefaults("config.yml", true, true);
        if (Objects.requireNonNull(this.configService.getConfig().getString("API_KEY")).isEmpty()) {
            this.logger.warning("the api key is missing!!");
            this.logger.info("disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.logger.info("loading weatherservice...");
        this.weatherService = new WeatherService(this);
        this.logger.info("starting checkup-services...");
        this.checkUpTask = new CheckUpTask(this);
        if (this.configService.getConfig().getBoolean("SyncTime") && this.configService.getConfig().getBoolean("SyncWeather")) {
            this.checkUpTask.start();
        }
        this.logger.info("loading commands...");
        this.getCommand("syncedweather").setExecutor((CommandExecutor)new SyncedWeatherCommand(this));
        this.logger.info("registering listeners...");
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.logger.info("loading placeholders...");
            new Placeholder(this).register();
        }
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.logger.info("loading ProtocolLib...");
            this.protocolManager = ProtocolLibrary.getProtocolManager();
            this.protocolHandler = new ProtocolHandler(this);
        }
        new UpdateCheckService(this, 97574).getVersion(version -> {
            if (!this.getDescription().getVersion().equals(version)) {
                this.isNewerVersion = true;
                this.logger.info("There is a new version of this plugin: https://www.spigotmc.org/resources/syncedweather.97574/!");
            }
        });
        new Metrics(this, 13631);
    }

    public void reload() {
        this.logger.info("loading the config...");
        this.configService.createDefaults("config.yml", true, true);
        if (Objects.requireNonNull(this.configService.getConfig().getString("API_KEY")).isEmpty()) {
            this.logger.warning("the api key is missing!!");
            this.logger.info("disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.logger.info("loading the weather...");
        this.weatherService.getWeather().update();
        this.logger.info("loading checkup-services...");
        if (this.configService.getConfig().getBoolean("SyncTime") && this.configService.getConfig().getBoolean("SyncWeather")) {
            this.checkUpTask.start();
        } else {
            this.checkUpTask.stop();
        }
    }

    public WeatherService getWeatherService() {
        return this.weatherService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public boolean isNewerVersion() {
        return this.isNewerVersion;
    }
}

