/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.luftigerlib.configuration.spigot;

import eu.luftiger.luftigerlib.configuration.spigot.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SpigotConfiguration {
    private final JavaPlugin plugin;
    private YamlConfiguration config;
    private File file;

    public SpigotConfiguration(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void createDefaults(String name, boolean copyDefault, boolean updateConfig) {
        this.createDefaults(name, copyDefault, updateConfig, this.plugin.getDataFolder().getPath());
    }

    public void createDefaults(String name, boolean copyDefault, boolean updateConfig, String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.file = new File(path + "/" + name);
        if (!this.file.exists()) {
            if (copyDefault) {
                InputStream inputStream = this.plugin.getResource(name);
                try {
                    assert (inputStream != null);
                    Files.copy(inputStream, Paths.get(this.plugin.getDataFolder().getPath() + "/" + name, new String[0]), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (updateConfig) {
            try {
                ConfigUpdater.update((Plugin)this.plugin, name, this.file, new ArrayList<String>());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public String getConverted(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.translateHEXCodes(this.config.getString(path))));
    }

    public String translateHEXCodes(String string) {
        Matcher matcher = Pattern.compile("<.*?>").matcher(string);
        while (matcher.find()) {
            String replace = matcher.group();
            string = string.replace(replace, ChatColor.of((String)replace.replace("<", "").replace(">", "")) + "");
        }
        return string;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

