/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.luftigerlib.configuration.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public abstract class BungeeConfiguration {
    private final Plugin plugin;
    private Configuration configuration;
    private ConfigurationProvider configurationProvider = ConfigurationProvider.getProvider(YamlConfiguration.class);
    private File file;

    protected BungeeConfiguration(Plugin plugin) {
        this.plugin = plugin;
    }

    public void createDefaults(String name, boolean copyDefault) {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.file = new File(this.plugin.getDataFolder().getPath() + "/" + name);
        if (!this.file.exists()) {
            if (copyDefault) {
                InputStream inputStream = this.plugin.getResourceAsStream(name);
                try {
                    assert (inputStream != null);
                    Files.copy(inputStream, Paths.get(this.plugin.getDataFolder().getPath() + "/" + name, new String[0]), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getConverted(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.configuration.getString(path));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public File getFile() {
        return this.file;
    }

    public void saveConfig() {
        try {
            this.configurationProvider.load(this.file);
            this.configurationProvider.save(this.configuration, this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

