/*
 * Decompiled with CFR 0.152.
 */
package eu.luftiger.luftigerlib.configuration.bungee;

import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.bukkit.event.EventHandler;

public abstract class BungeeCommunicationHandler
implements Listener {
    protected final Plugin plugin;

    public BungeeCommunicationHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public abstract void onPluginMessage(PluginMessageEvent var1);

    public void send(ServerInfo server, @Nullable String subchannel, Object ... params) {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(b);){
            if (subchannel != null && !subchannel.equals("")) {
                out.writeUTF(subchannel);
            }
            for (Object param : params) {
                if (param instanceof String) {
                    out.writeUTF((String)param);
                    continue;
                }
                if (param instanceof Integer) {
                    out.writeInt((Integer)param);
                    continue;
                }
                if (param instanceof Double) {
                    out.writeDouble((Double)param);
                    continue;
                }
                if (param instanceof Float) {
                    out.writeFloat(((Float)param).floatValue());
                    continue;
                }
                if (param instanceof Boolean) {
                    out.writeBoolean((Boolean)param);
                    continue;
                }
                if (param instanceof Short) {
                    out.writeShort(((Short)param).shortValue());
                    continue;
                }
                if (param instanceof Long) {
                    out.writeLong((Long)param);
                    continue;
                }
                if (param instanceof Byte) {
                    out.writeByte(((Byte)param).byteValue());
                    continue;
                }
                if (param instanceof Character) {
                    out.writeChar(((Character)param).charValue());
                    continue;
                }
                if (!(param instanceof JsonObject)) continue;
                out.writeUTF(((JsonObject)param).toString());
            }
            this.plugin.getProxy().getScheduler().runAsync(this.plugin, () -> server.sendData("BungeeCord", b.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

