package me.fullpage.tvouchers.utilities;

import me.fullpage.tvouchers.TVouchers;
import me.fullpage.tvouchers.managers.Base;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Utils extends Base {

    private static Plugin plugin = TVouchers.getInstance();


    public static void sendMessageToPermission(String message, Permissions permission) {
        Bukkit.getServer().getOnlinePlayers().stream().filter(player -> player.hasPermission(permission.getPermission())).forEach(player -> player.sendMessage(ChatColor.translateAlternateColorCodes('&', message)));
    }

    public static boolean isNotNullOrEmpty(String str){
        return (str != null && !str.isEmpty());
    }

    public static boolean isPlayerInGroup(Player player, String group) {
        return player.hasPermission("group." + group);
    }

    public static GlueList<Long> extractNumbers(final String str) {
        GlueList<Long> list = new GlueList<>();
        StringBuilder sb = new StringBuilder();
        boolean found = false;
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) {
                sb.append(c);
                found = true;
            } else if (found) {
                list.add(Long.valueOf(sb.toString()));
                sb = new StringBuilder();
                found = false;
            }
        }
        if (!sb.toString().isEmpty())
            list.add(Long.valueOf(sb.toString()));
        return list;
    }

    public static String randomNumberFromPlaceholder(String command) {
        final String upperCaseCommand = command.toUpperCase();
        if (upperCaseCommand.contains("{RANGE;")) {
            final int start = upperCaseCommand.indexOf("{RANGE;");
            if (upperCaseCommand.substring(start).contains("}")) {
                final String placeholder = command.substring(start, command.lastIndexOf("}") + 1);
                final boolean isPlaceholder = placeholder.toUpperCase().matches("\\{RANGE;[0-9]+-[0-9]+}");
                if (isPlaceholder) {
                    final GlueList<Long> list = extractNumbers(command);
                    return new SString(command).replaceIgnoreCase(placeholder, TVouchers.getRand().nextLong(list.get(0), list.get(1)) + "").get();
                }
            }
        }
        return command;
    }


    public static void removeSingleItemFromHand(Player player) {
        ItemStack hand = player.getItemInHand();
        if (hand.getAmount() == 1)
            player.setItemInHand(null);
        else hand.setAmount(hand.getAmount() - 1);
    }
}
