package me.fullpage.tvouchers.utilities;


import org.apache.commons.lang.StringUtils;

import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static String formatTime(long playTime) {
        long millis = playTime;
        String output = "";
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        millis -= TimeUnit.DAYS.toMillis(days);
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        millis -= TimeUnit.HOURS.toMillis(hours);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        millis -= TimeUnit.MINUTES.toMillis(minutes);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        if (days > 1L) {
            output = output + days + " days ";
        } else if (days == 1L) {
            output = output + days + " day ";
        }
        if (hours > 1L) {
            output = output + hours + " hours ";
        } else if (hours == 1L) {
            output = output + hours + " hour ";
        }
        if (minutes > 1L) {
            output = output + minutes + " minutes ";
        } else if (minutes == 1L) {
            output = output + minutes + " minute ";
        }
        if (seconds > 1L) {
            output = output + seconds + " seconds ";
        } else if (seconds == 1L) {
            output = output + seconds + " second ";
        }
        if (output.isEmpty())
            return "0 seconds";
        return StringUtils.trim(output);
    }
}
