package me.fullpage.tvouchers.utilities;

public class SString {

    private final String string;

    public SString(String str) {
        this.string = str;
    }

    public SString replaceIgnoreCase(String value, String replacement) {
        return new SString(this.string.replaceAll("(?i)" + removeIllegal(value), removeIllegal(replacement)));
    }

    public boolean contains(CharSequence val) {
        return this.string.contains(val);
    }

    public boolean containsIgnoreCase(String s) {
        return this.string.toLowerCase().contains(s.toLowerCase());
    }

    public SString remove(String value) {
        return new SString(string.replace(value, ""));
    }

    public SString removeIgnoreCase(String value) {
        return new SString(this.string.replaceAll("(?i)" + removeIllegal(value), ""));
    }

    public String get() {
        return this.string;
    }

    public String colourise() {
        return this.string.replace("&", "§");
    }

    public String[] split(String regex) {
        return this.string.split(regex);
    }

    @Override
    public String toString() {
        return this.string;
    }

    private String removeIllegal(String str) {
        return str.replace("%", "%%").replace("$", "\\$").replace("{", "\\{").replace("}", "\\}".replace("[", "\\[".replace("]", "\\]")));
    }

}
