package me.fullpage.tvouchers.managers.cooldowns;

import org.bukkit.entity.Player;

import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {

    private final Player player;
    private final String cooldownKey;

    private long cooldownInSeconds = 0;
    private long endTimeInMillis = 0L;

    //todo handle expired cooldowns

    public static final ConcurrentHashMap<String, Long> cooldownMap = new ConcurrentHashMap<>();

    public CooldownManager(Player player, String cooldownKey) {
        this.player = player;
        this.cooldownKey = cooldownKey.toLowerCase();
    }

    public static ConcurrentHashMap<String, Long> getCooldownMap() {
        return cooldownMap;
    }

    public void putOnCooldown(int cooldownInSeconds, long currentTimeMillis) {
        this.cooldownInSeconds = cooldownInSeconds;
        this.endTimeInMillis = currentTimeMillis + (cooldownInSeconds * 1000L);
        cooldownMap.put(getKey(), this.endTimeInMillis);
    }

    public long getSecondsRemaining() {
        return this.cooldownInSeconds - ((System.currentTimeMillis() - cooldownMap.get(getKey())) / 1000L);
    }

    public boolean isOnCooldown() {
        if (cooldownMap.get(getKey()) == null)
            return false;
        return getSecondsRemaining() > 0L;
    }

    public String getKey() {
        return this.player.getUniqueId() + ";" + this.cooldownKey.toLowerCase();
    }

    @Override
    public String toString() {
        return this.player.getUniqueId() + ";" + this.cooldownKey.toLowerCase() +
                ";" + endTimeInMillis;
    }
}
