package me.fullpage.tvouchers.managers;

import java.math.BigDecimal;

public class Time {
    private long duration;
    private TimeUnit timeUnit;



    public Time(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public BigDecimal getTime(TimeUnit timeUnit) {
        BigDecimal time = BigDecimal.valueOf(this.duration);

        if (this.timeUnit == TimeUnit.TICKS) {
            if (timeUnit == TimeUnit.SECONDS) {
                time = BigDecimal.valueOf(this.duration / 20);
            } else if (timeUnit == TimeUnit.MILLISECONDS) {
                time = BigDecimal.valueOf((this.duration / 20) * 1000);
            } else if (timeUnit == TimeUnit.MINUTES) {
                time = BigDecimal.valueOf((this.duration / 20) / 60);
            } else if (timeUnit == TimeUnit.HOURS) {
                time = BigDecimal.valueOf((this.duration / 20) / 60);

            }

        } else if (this.timeUnit == TimeUnit.SECONDS) {
            if (timeUnit == TimeUnit.TICKS) {
                time = BigDecimal.valueOf(this.duration * 20);
            } else if (timeUnit == TimeUnit.MILLISECONDS) {
                time = BigDecimal.valueOf(this.duration * 1000);
            } else if (timeUnit == TimeUnit.MINUTES) {
                time = BigDecimal.valueOf(this.duration / 60);
            } else if (timeUnit == TimeUnit.HOURS) {
                time = BigDecimal.valueOf((this.duration / 60) /60);
            }

        } else if (this.timeUnit == TimeUnit.MILLISECONDS) {
            if (timeUnit == TimeUnit.TICKS) {
                time = BigDecimal.valueOf(new Time(this.duration, TimeUnit.MILLISECONDS).getTime(TimeUnit.SECONDS).longValue() * 20);
            } else if (timeUnit == TimeUnit.SECONDS) {
                time = BigDecimal.valueOf(this.duration / 1000);
            } else if (timeUnit == TimeUnit.MINUTES) {
                time = BigDecimal.valueOf((this.duration / 1000) / 60);
            } else if (timeUnit == TimeUnit.HOURS) {
                time = BigDecimal.valueOf(((this.duration / 1000) / 60) / 60);
            }
        } else if (this.timeUnit == TimeUnit.MINUTES) {
            if (timeUnit == TimeUnit.TICKS) {
                time = BigDecimal.valueOf((this.duration * 60) * 20);
            } else if (timeUnit == TimeUnit.MILLISECONDS) {
                time = BigDecimal.valueOf((this.duration * 60) * 1000);
            } else if (timeUnit == TimeUnit.SECONDS) {
                time = BigDecimal.valueOf(this.duration * 60);
            } else if (timeUnit == TimeUnit.HOURS) {
                time = BigDecimal.valueOf(this.duration / 60);
            }
        }
        return time;
    }

    public enum TimeUnit {
        TICKS,
        MILLISECONDS,
        SECONDS,
        MINUTES,
        HOURS
    }

}
