package me.fullpage.tvouchers.managers;

import de.themoep.inventorygui.GuiElement;
import de.themoep.inventorygui.InventoryGui;
import de.themoep.inventorygui.StaticGuiElement;
import me.fullpage.core.utilities.XMaterial;
import me.fullpage.tvouchers.TVouchers;
import me.fullpage.tvouchers.data.Config;
import me.fullpage.tvouchers.data.ConfigManager;
import me.fullpage.tvouchers.hooks.VaultHook;
import me.fullpage.tvouchers.utilities.CM;
import me.fullpage.tvouchers.utilities.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import static me.fullpage.tvouchers.listeners.VoucherListener.runTitleThing;

public class GUI extends Base {

    private final String title;
    private final String materialName;
    private final Integer materialData;
    private final List<String> lore;
    private InventoryGui gui;
    private final Boolean glow;
    private List<GuiElement> guiElements;

    public GUI(List<String> guiSetup, String title, String materialName, Integer materialData, List<String> lore, Boolean glow, GuiElement... guiElements) {
        this.title = title;
        this.materialName = materialName;
        this.materialData = materialData;
        this.lore = translateList(lore);
        this.gui = setupGui(new InventoryGui(JavaPlugin.getProvidingPlugin(TVouchers.class), null, title, guiSetup.toArray(new String[0])));
        this.glow = glow;
        this.guiElements = Arrays.asList(guiElements);
    }

    public InventoryGui setupGui() {
        return setupGui(this.gui);
    }

    private InventoryGui setupGui(InventoryGui gui) {
        guiElements.forEach(gui::addElement);
        return this.gui;
    }

    private static HashMap<String, InventoryGui> guiMap = new HashMap<>();

    public static HashMap<String, InventoryGui> getGuiMap() {
        return guiMap;
    }

    public static InventoryGui getDefault() {
        return guiMap.getOrDefault("DEFAULT_GUI", loadDefault());
    }

    public static InventoryGui loadDefault() {
        final ConfigManager guiManager = new ConfigManager("gui.yml");
        final FileConfiguration guiConfig = guiManager.getConfig();
        InventoryGui gui = new InventoryGui(JavaPlugin.getProvidingPlugin(TVouchers.class), null, Config.GUI_TITLE, Config.GUI_SETUP.toArray(new String[0]));
        for (String key : guiManager.getConfig().getConfigurationSection("GUI").getKeys(false)) {
            key = key.replace(" ", "");
            String material = (String) guiConfig.get("GUI." + key + ".MATERIAL");
            int damage = (int) guiConfig.get("GUI." + key + ".DAMAGE", 0);
            String title = (String) guiConfig.get("GUI." + key + ".TITLE", "Put Title Here");
            List<String> lore = (List<String>) guiConfig.get("GUI." + key + ".LORE", new ArrayList<>());
            if (material == null) continue;
            boolean glow = (Boolean) guiConfig.get("GUI." + key + ".GLOW", false);
            Material mat = XMaterial.matchXMaterial(material.toUpperCase()).get().parseMaterial();
            if (mat == null) continue;
            GUIAction guiAction = GUIAction.get((String) guiConfig.get("GUI." + key + ".ACTION", GUIAction.NONE.toString()));

            ItemStack itemStack = new ItemStack(mat, 1);
            if (itemStack.getType().name().toUpperCase().endsWith("_PANE")) {
                itemStack = me.fullpage.core.utilities.Utils.glassFromNumber(damage);
            } else {
                itemStack.setDurability((short) damage);
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (glow) {
                itemMeta.addEnchant(Enchantment.OXYGEN, 1, true);
                itemMeta.addItemFlags(ItemFlag.HIDE_PLACED_ON);
                itemMeta.addItemFlags(ItemFlag.HIDE_ENCHANTS);
                itemMeta.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
            }
            itemStack.setItemMeta(itemMeta);

            List<String> abc = new ArrayList<>();
            abc.add(title);
            abc.addAll(lore);

            gui.addElement(new StaticGuiElement(key.charAt(0),
                    itemStack,
                    1, // Display a number as the item count
                    click -> {
                        switch (guiAction) {
                            case DENY:
                                click.getWhoClicked().closeInventory();
                                return true;
                            case ACCEPT:
                                Player player = (Player) click.getWhoClicked();
                                Voucher voucher = new Voucher(click.getWhoClicked().getItemInHand());
                                voucher.removeSingleItemFromHand((Player) click.getWhoClicked());
                                click.getWhoClicked().sendMessage(CM.colourStr(voucher.getSuccessMessageFromItem()));
                                voucher.runCommands(((Player) click.getWhoClicked()));
                                if (voucher.isMoneyVoucher() && voucher.getTitleScreenFromItem()) {
                                    String moneyString = Utils.randomNumberFromPlaceholder(voucher.getMoneyFromVoucher());
                                    runTitleThing((Player) click.getWhoClicked(), moneyString);
                                } else if (voucher.isMoneyVoucher() && !voucher.getTitleScreenFromItem()) {
                                    String amount = Utils.randomNumberFromPlaceholder(voucher.getMoneyFromVoucher());
                                    new VaultHook().giveMoney((Player) click.getWhoClicked(), Double.parseDouble(amount), "&aYou have won {MONEY}!");
                                }

                                if (Utils.isNotNullOrEmpty(voucher.getSoundFromItem())) {
                                    player.playSound(player.getLocation(), Sound.valueOf(voucher.getSoundFromItem()), 4f, 4f);
                                }

                                voucher.putCooldown((Player) click.getWhoClicked());
                                click.getWhoClicked().closeInventory();
                                return true;
                        }
                        return true; // returning false will not cancel the initial click event to the gui
                        // returning true will cancel the click event and stop taking the item
                    },
                    abc.toArray(new String[0])
            ));

        }
        guiMap.put("DEFAULT_GUI", gui);
        return gui;
    }

    public void openInventory(Player player) {
        this.gui.show(player);
    }

    public InventoryGui getGui() {
        return this.gui;
    }

    public String getTitle() {
        return gui.getTitle();
    }

    public Boolean getGlow() {
        return glow;
    }

    public Integer getMaterialData() {
        return materialData;
    }

    public List<String> getLore() {
        return lore;
    }

    public String getMaterialName() {
        return materialName;
    }

    private List<String> translateList(List<String> list) {
        return list.stream().map(l -> ChatColor.translateAlternateColorCodes('&', l)).collect(Collectors.toList());
    }
}
