package me.fullpage.tvouchers.listeners;

import me.fullpage.tvouchers.TVouchers;
import me.fullpage.tvouchers.data.Config;
import me.fullpage.tvouchers.hooks.VaultHook;
import me.fullpage.tvouchers.managers.Base;
import me.fullpage.tvouchers.managers.GUI;
import me.fullpage.tvouchers.managers.Voucher;
import me.fullpage.tvouchers.utilities.*;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class VoucherListener extends Base implements Listener {

    //todo enderportal check anvil

    private static int taskID = 0;

    private static HashMap<UUID, Long> list = new HashMap<>();


    @EventHandler(priority = EventPriority.HIGHEST)
    public void onVoucherClick(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (player == null) return;
        final ItemStack hand = player.getItemInHand();
        if (hand == null || hand.getType() == null || hand.getType().equals(Material.AIR) || !hand.hasItemMeta())
            return;
        if (event.getAction().equals(Action.RIGHT_CLICK_AIR) || event.getAction().equals(Action.RIGHT_CLICK_BLOCK)) {
            final Voucher voucher = new Voucher(hand);
            if (!voucher.isVoucher()) return;
            event.setCancelled(true);

            if (Utils.isNotNullOrEmpty(voucher.getPermission()) && !player.hasPermission(voucher.getPermission())) {
                player.sendMessage("&cYou do not have permission to use this voucher! (" + voucher.getPermission() + ")");
                return;
            }

            if (voucher.isMoneyVoucher() && voucher.getTitleScreenFromItem() && list.containsKey(player.getUniqueId()) && !((System.currentTimeMillis() - list.get(player.getUniqueId())) >= 60000)) {
                player.sendMessage(new SString("&cPlease wait for your current money voucher to finish!").colourise());
                return;
            }


            if (voucher.isOnCooldown(player))
                return;

            if (Config.ENABLE_GUI && voucher.isGui()) {
                GUI.getDefault().show(player);
                return;
            } else {
                voucher.putCooldown(player);
                voucher.runCommands(player);
                if (voucher.isMoneyVoucher() && voucher.getTitleScreenFromItem()) {
                    String moneyString = Utils.randomNumberFromPlaceholder(voucher.getMoneyFromVoucher());
                    runTitleThing(player, moneyString);
                } else if (voucher.isMoneyVoucher() && !voucher.getTitleScreenFromItem()) {
                    String amount = Utils.randomNumberFromPlaceholder(voucher.getMoneyFromVoucher());
                    new VaultHook().giveMoney(player, Double.parseDouble(amount), "&aYou have won {MONEY}!");
                }

            }
            voucher.removeSingleItemFromHand(player);
            if (Utils.isNotNullOrEmpty(voucher.getSoundFromItem())) {
                player.playSound(player.getLocation(), Sound.valueOf(voucher.getSoundFromItem()), 4f, 4f);
            }
            player.sendMessage(CM.colourStr(voucher.getSuccessMessageFromItem()));
        }

    }

    private static String getSymbols(String str, String symbol, int extra) {
        StringBuilder myName = new StringBuilder();
        for (int i = 0; i < str.length() + extra; i++) {
            myName.append(symbol);
        }
        return myName.toString();
    }

    public static void runTitleThing(Player player, String amount) {
        final long currentTime = System.currentTimeMillis();
        list.put(player.getUniqueId(), currentTime);
        AtomicInteger length = new AtomicInteger(amount.length());
        StringBuilder initialSymbols = new StringBuilder(getSymbols(amount, Config.MONEY_TITLE_INITIAL_SYMBOL, 0));
        VaultHook vault = new VaultHook();
        StringBuilder test = new StringBuilder();
        int seconds = length.get();
        double money = Double.parseDouble(amount);
        String formattedMoney = vault.getEconomy().format(money);
        CountdownTimer countdownTimer = new CountdownTimer(TVouchers.getProvidingPlugin(VoucherListener.class), seconds, () -> {
            me.fullpage.core.utilities.TitleAPI.sendTitle(player, 0, 23, 0, new SString(Config.MONEY_TITLE_SCREEN_TITLE_1).replaceIgnoreCase("{INITIAL_SYMBOLS}", initialSymbols.toString()).replaceIgnoreCase("{PLAYER}", player.getName()).colourise(), new SString(Config.MONEY_TITLE_SCREEN_SUBTITLE_1).replaceIgnoreCase("{PLAYER}", player.getName()).colourise());
        }, () -> {
            me.fullpage.core.utilities.TitleAPI.sendTitle(player, 0, 43, 20, new SString(Config.MONEY_TITLE_SCREEN_TITLE_3).replaceIgnoreCase("{PLAYER}", player.getName()).replaceIgnoreCase("{WINNINGS}", vault.getEconomy().format(money)).colourise(), new SString(Config.MONEY_TITLE_SCREEN_SUBTITLE_3).replaceIgnoreCase("{WINNINGS}", formattedMoney).replaceIgnoreCase("{PLAYER}", player.getName()).colourise());
            vault.giveMoney(player, money, "&aYou have won {MONEY}!");
            list.remove(player.getUniqueId());
        }, countdownTimer1 -> {
            int a = length.getAndDecrement();
            initialSymbols.deleteCharAt(a - 1);
            test.append(amount.charAt(a - 1));
            me.fullpage.core.utilities.TitleAPI.sendTitle(player, 0, 23, 0, new SString(Config.MONEY_TITLE_SCREEN_TITLE_2).replaceIgnoreCase("{INITIAL_SYMBOLS}", initialSymbols.toString()).replaceIgnoreCase("{WINNINGS}", new StringBuilder(test).reverse().toString()).replaceIgnoreCase("{PLAYER}", player.getName()).colourise(), new SString(Config.MONEY_TITLE_SCREEN_SUBTITLE_2).replaceIgnoreCase("{INITIAL_SYMBOLS}", initialSymbols.toString()).replaceIgnoreCase("{WINNINGS}", new StringBuilder(test).reverse().toString()).replaceIgnoreCase("{PLAYER}", player.getName()).colourise());
        });
        countdownTimer.scheduleTimer();
    }

}
