package me.fullpage.tvouchers.hooks;

import me.fullpage.tvouchers.utilities.CM;
import me.fullpage.tvouchers.utilities.SString;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

import static org.bukkit.Bukkit.getServer;

public class VaultHook {
    private static Chat chat = null;

    private static boolean setupChat() {
        RegisteredServiceProvider<Chat> rsp = getServer().getServicesManager().getRegistration(Chat.class);
        chat = rsp.getProvider();
        return chat != null;
    }

    public boolean getVault() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null;
    }

    public boolean isPlayerInGroup(Player player, String group) {
        return player.hasPermission("group." + group);
    }

    public boolean setupPermissions() {
        RegisteredServiceProvider<Permission> rsp = getServer().getServicesManager().getRegistration(Permission.class);
        Permission perms = rsp.getProvider();
        return perms != null;
    }

    public Permission getPermission() {
        RegisteredServiceProvider<Permission> rsp = getServer().getServicesManager().getRegistration(Permission.class);
        return rsp.getProvider();
    }

    public static Chat getChat() {
        if (chat == null)
            setupChat();
        return chat;
    }
    private boolean setupEconomy() {
        if (getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider<Economy> rsp = getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        Economy econ = rsp.getProvider();
        return econ != null;
    }

    public Economy getEconomy() {
        if (getServer().getPluginManager().getPlugin("Vault") == null) {
            return null;
        }
        RegisteredServiceProvider<Economy> rsp = getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return null;
        }
        Economy econ = rsp.getProvider();
        return econ;
    }

    public void giveMoney(Player player, double amount) {
        Economy economy = getEconomy();
        if (economy != null) {
            economy.depositPlayer(player, amount);
            player.sendMessage(CM.colourStr("&aYou have been given " + economy.format(amount)));
        }
    }

    public void giveMoney(Player player, double amount, String message) {
        Economy economy = getEconomy();
        if (economy != null) {
            economy.depositPlayer(player, amount);
            player.sendMessage(new SString(message).replaceIgnoreCase("{PLAYER}", player.getName()).replaceIgnoreCase("{MONEY}", economy.format(amount)).colourise());
        }
    }

}
