package me.fullpage.tvouchers.data;

import me.fullpage.tvouchers.TVouchers;
import me.fullpage.tvouchers.managers.cooldowns.CooldownManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class Data {

    public static final ConfigManager dataManager = new ConfigManager("data.yml");
    public static FileConfiguration data = dataManager.getConfig();

    static {
        for (String key : data.getKeys(false)) {
            CooldownManager.cooldownMap.put(key, data.getLong(key));
        }
    }

    public static void saveData() {
        for (String key : CooldownManager.cooldownMap.keySet()) {
            boolean a = CooldownManager.cooldownMap.get(key) != null && CooldownManager.cooldownMap.get(key) > System.currentTimeMillis();
            if (a)
                data.set(key, CooldownManager.cooldownMap.get(key));
            else {
                CooldownManager.cooldownMap.remove(key);
                data.set(key, null);
            }
        }
        dataManager.saveConfig();
    }

    public static void loopSaveData() {
        Bukkit.getScheduler().runTaskTimer(TVouchers.getInstance(), Data::saveData, 1200, 1200);
    }


}
