package me.fullpage.tvouchers.data;

import me.fullpage.tvouchers.TVouchers;
import me.fullpage.tvouchers.managers.Base;
import org.bukkit.configuration.file.FileConfiguration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Config extends Base {

    public static final ConfigManager configManager = new ConfigManager("config.yml");
    public static FileConfiguration config = configManager.getConfig();

    public static final ConfigManager voucherManager = new ConfigManager("voucher.yml");
    public static FileConfiguration voucher = voucherManager.getConfig();

    public static final ConfigManager guiManager = new ConfigManager("gui.yml");
    public static FileConfiguration gui = guiManager.getConfig();
    public static boolean STARTUP = true;

    public static boolean ENABLE_GUI;
    public static List<String> GUI_SETUP;
    public static String GUI_TITLE;

    public static String DEFAULT_SUCCESS_MESSAGE;
    public static String DEFAULT_COOLDOWN_MESSAGE;

    public static String RECEIVED_VOUCHER;

    public static boolean TIME_FORMATTED;


    public static String IDENTIFIER;

    public static void loadIdentifier() {
        ConfigManager identifierManager = new ConfigManager("do-not-touch.yml");
        identifierManager.createFile();
        FileConfiguration identifier = identifierManager.getConfig();
        header(identifier, "TVouchers Identifier\n" +
                "(DO NOT TOUCH UNLESS YOU KNOW WHAT THIS DOES)\n" +
                "This randomly generated key is given to each voucher - differentiating it from other items.\n" +
                "If this key is reset all previous vouchers will become void (won't work).");

        IDENTIFIER = getString(identifier, "Identifier", TVouchers.getRandomString().nextString());
        identifierManager.saveConfig();

    }

    public static String MONEY_TITLE_SCREEN_TITLE_1;
    public static String MONEY_TITLE_SCREEN_SUBTITLE_1;
    public static String MONEY_TITLE_SCREEN_TITLE_2;
    public static String MONEY_TITLE_SCREEN_SUBTITLE_2;
    public static String MONEY_TITLE_SCREEN_TITLE_3;
    public static String MONEY_TITLE_SCREEN_SUBTITLE_3;
    public static String MONEY_TITLE_INITIAL_SYMBOL;

    public static String LICENSE;

    public static void loadConfig() {
        new ConfigManager("config.yml").createFile();
        new ConfigManager("data.yml").createFile();
        new ConfigManager("gui.yml").createFile();
        new ConfigManager("voucher.yml").createFile();
        if (!STARTUP) {
            configManager.reloadConfig();
            voucherManager.reloadConfig();
            guiManager.reloadConfig();
        }
        STARTUP = false;

        header(config, "TVouchers General Configuration");

        //LICENSE = getString(config, "LICENSE", "");

        ENABLE_GUI = getBoolean(config, "features.ENABLE_GUI", true);
        DEFAULT_SUCCESS_MESSAGE = getString(config, "DEFAULT_SUCCESS_MESSAGE", "&aYou have successfully redeemed this voucher!");
        DEFAULT_COOLDOWN_MESSAGE = getString(config, "DEFAULT_COOLDOWN_MESSAGE", "&cYou can use this for another {TIME}!");
        RECEIVED_VOUCHER = getString(config, "RECEIVED_VOUCHER", "&aYou have been given {AMOUNT}x {VOUCHER} vouchers!");
        TIME_FORMATTED = getBoolean(config, "TIME_FORMATTED", true);

        MONEY_TITLE_INITIAL_SYMBOL = getString(config, "moneyTitleScreen.INITIAL_SYMBOL", "$");
        MONEY_TITLE_SCREEN_TITLE_1 = getString(config, "moneyTitleScreen.TITLE_1", "&e&l{INITIAL_SYMBOLS}");
        MONEY_TITLE_SCREEN_SUBTITLE_1 = getString(config, "moneyTitleScreen.SUBTITLE_1", "&eGood luck!");
        MONEY_TITLE_SCREEN_TITLE_2 = getString(config, "moneyTitleScreen.TITLE_2", "&e&l$&e&l&k{INITIAL_SYMBOLS}&e&l{WINNINGS}");
        MONEY_TITLE_SCREEN_SUBTITLE_2 = getString(config, "moneyTitleScreen.SUBTITLE_2", "&eGood luck!");
        MONEY_TITLE_SCREEN_TITLE_3 = getString(config, "moneyTitleScreen.TITLE_3", "&a&lYou won");
        MONEY_TITLE_SCREEN_SUBTITLE_3 = getString(config, "moneyTitleScreen.SUBTITLE_3", "&a&l{WINNINGS}");

        Map<String, Object> map = new LinkedHashMap<>();
        Map<String, Object> a = new LinkedHashMap<>();
        Map<String, Object> b = new LinkedHashMap<>();
        Map<String, Object> c = new LinkedHashMap<>();

        a.put("MATERIAL", "STAINED_GLASS_PANE");
        a.put("DAMAGE", 7);
        a.put("TITLE", " ");
        a.put("LORE", Collections.singletonList(" "));
        a.put("GLOW", false);
        a.put("ACTION", "NONE");
        b.put("MATERIAL", "STAINED_GLASS_PANE");
        b.put("DAMAGE", 5);
        b.put("TITLE", "&a&lConfirm");
        b.put("LORE", Collections.singletonList("&7&oClick to admit to confirm."));
        b.put("GLOW", true);
        b.put("ACTION", "ACCEPT");
        c.put("MATERIAL", "STAINED_GLASS_PANE");
        c.put("DAMAGE", 14);
        c.put("TITLE", "&a&lDeny");
        c.put("LORE", Collections.singletonList("&7&oClick to admit to deny."));
        c.put("GLOW", true);
        c.put("ACTION", "DENY");

        map.put("a", a);
        map.put("b", b);
        map.put("c", c);


        header(gui, "TVouchers Default GUI Configuration\n\nCurrent Action Types: ACCEPT, DENY & NONE");
        GUI_SETUP = getStringList(gui, "GUI_SETUP", Collections.singletonList("aaabacaaa"));
        get(gui, "GUI", map);
        GUI_TITLE = getString(gui, "GUI_TITLE", "Confirmation GUI");

        header(voucher, "TVouchers Voucher Configuration\n\nPlaceholders: {PLAYER} & {RANGE;from-to}\n(FYI COOLDOWN IS IN SECONDS)\n");

        Map<String, Object> exampleVoucher = new LinkedHashMap<>();
        exampleVoucher.put("MATERIAL", "APPLE");
        exampleVoucher.put("DAMAGE", 0);
        exampleVoucher.put("ITEM_NAME", "&6&lAnnouncing Apple");
        exampleVoucher.put("ITEM_LORE", Collections.singletonList("&7&o(Click to announce a message)"));
        exampleVoucher.put("GLOW", true);
        exampleVoucher.put("GUI", false);
        exampleVoucher.put("COMMANDS", Collections.singletonList("say Hello world! Announced by {PLAYER}!"));
        exampleVoucher.put("PERMISSION", "");
        exampleVoucher.put("COOLDOWN", 0);
        exampleVoucher.put("SUCCESS_MESSAGE", "&aYou have successfully redeemed your &6&lAnnouncing Apple");
        exampleVoucher.put("COOLDOWN_MESSAGE", "&cYou can't do this for another {TIME}");

        Map<String, Object> moneyVoucher = new LinkedHashMap<>();
        moneyVoucher.put("MATERIAL", "PAPER");
        moneyVoucher.put("DAMAGE", 0);
        moneyVoucher.put("ITEM_NAME", "&e&lTier I Money Voucher");
        moneyVoucher.put("ITEM_LORE", Collections.singletonList("&7&o(Click to generate money between $1,000 and $50,000!)"));
        moneyVoucher.put("GLOW", true);
        moneyVoucher.put("GUI", true);
        //moneyVoucher.put("COMMANDS", Collections.singletonList("eco give {PLAYER} {RANGE;1000-50000}"));
        moneyVoucher.put("PERMISSION", "");
        moneyVoucher.put("COOLDOWN", 5);
        moneyVoucher.put("SUCCESS_MESSAGE", "&aYou have redeemed your money voucher!");
        moneyVoucher.put("COOLDOWN_MESSAGE", "&cYou can't do this for another {TIME}");
        moneyVoucher.put("TITLE_SCREEN", true);
        moneyVoucher.put("MONEY", "{RANGE;1000-50000}");
        moneyVoucher.put("SOUND", "ANVIL_USE");

        if (voucher.getConfigurationSection("Vouchers") == null) {
            voucher.set("Vouchers.Example_Voucher", exampleVoucher);
            voucher.set("Vouchers.Money_Voucher", moneyVoucher);
        }


        configManager.saveConfig();
        voucherManager.saveConfig();
        guiManager.saveConfig();
    }

    public static Object get(FileConfiguration config, String key, Object defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.get(key);
    }

    public static String getString(FileConfiguration config, String key, String defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.getString(key);
    }

    public static List<String> getStringList(FileConfiguration config, String key, List<String> defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.getStringList(key);
    }

    public static Integer getInt(FileConfiguration config, String key, int defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.getInt(key);
    }

    public static Double getDouble(FileConfiguration config, String key, double defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.getDouble(key);
    }

    public static Boolean getBoolean(FileConfiguration config, String key, boolean defaultValue) {
        if (config.get(key) == null) {
            config.set(key, defaultValue);
            return defaultValue;
        } else return config.getBoolean(key);
    }

    private static void header(FileConfiguration f, String str) {
        str = "-------------------------------------------\n\n" + str + "\nMade by Fullpage\nVersion: " + TVouchers.getInstance().getDescription().getVersion() + "\n\n-------------------------------------------";
        f.options().header(str);
    }


}
