package me.fullpage.core.wrappers;

import java.util.UUID;

public class FObject {

    private final Object object;

    public FObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        try {
            return object;
        } catch (Exception e) {
            return null;
        }
    }

    public Long asLong() {
        try {
            return (Long) object;
        } catch (Exception e) {
            return null;
        }
    }

    public Integer asInt() {
        try {
            return (Integer) object;
        } catch (Exception e) {
            return null;
        }
    }

    public Double asDouble() {
        try {
            return (Double) object;
        } catch (Exception e) {
            return null;
        }
    }

    public Float asFloat() {
        try {
            return (Float) object;
        } catch (Exception e) {
            return null;
        }
    }

    public String asString() {
        try {
            return (String) object;
        } catch (Exception e) {
            return null;
        }
    }

    public Boolean asBoolean() {
        try {
            return (Boolean) object;
        } catch (Exception e) {
            return null;
        }
    }

    public UUID asUUID() {
        try {
            return UUID.fromString(asString());
        } catch (Exception e) {
            return null;
        }
    }

}
