package me.fullpage.core.utilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SortMap {

    private final LinkedHashMap<?, ? extends Number> sortedMap;
    private final boolean reverseOrder;
    private final List<Object> keyList = new ArrayList<>();
    private final List<Object> valueList = new ArrayList<>();

    public SortMap(Map<?, ? extends Number> map, boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
        if (reverseOrder) {
            this.sortedMap = map.entrySet()
                    .stream()
                    .sorted((o1, o2) -> ((Comparable<Number>) o2.getValue()).compareTo(o1.getValue()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        } else {
            this.sortedMap = map.entrySet()
                    .stream()
                    .sorted((o1, o2) -> ((Comparable<Number>) o1.getValue()).compareTo(o2.getValue()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        }
        for (Object obj : sortedMap.keySet()) {
            keyList.add(obj);
            valueList.add(sortedMap.get(obj));
        }
    }

    public LinkedHashMap<?, ? extends Number> getSortedMap() {
        return sortedMap;
    }

    public boolean isReverseOrder() {
        return reverseOrder;
    }

    public List<Object> getKeyList() {
        return keyList;
    }

    public List<Object> getValueList() {
        return valueList;
    }

    public Object getKeyAtIndex(int index) {
        if (index < keyList.size()) {
            return keyList.get(index);
        } else {
            return keyList.get(keyList.size() - 1);
        }
    }

    public Object getValueAtIndex(int index) {
        if (index < valueList.size()) {
            return valueList.get(index);
        } else {
            return valueList.get(valueList.size() - 1);
        }
    }
}