package me.fullpage.core.utilities;

import org.bukkit.ChatColor;

public class SString {

    private String string;

    public SString(String str) {
        this.string = str;
    }

    public SString replaceIgnoreCase(String value, String replacement) {
        return replacer(value, replacement, true);
    }

    public SString replaceIgnoreCase(String value, Number replacement) {
        return replacer(value, String.valueOf(replacement), true);
    }

    public SString replace(String value, String replacement) {
        return replacer(value, replacement, false);
    }


    public SString replace(String value, Number replacement) {
        return replacer(value, String.valueOf(replacement), false);
    }

    public boolean contains(CharSequence val) {
        return this.string.contains(val);
    }

    public boolean containsIgnoreCase(String s) {
        return this.string.toLowerCase().contains(s.toLowerCase());
    }

    public SString remove(String value) {
        return replacer(value, "", false);
    }

    public SString removeIgnoreCase(String value) {
        return replacer(value, "", true);
    }

    public String get() {
        return this.string;
    }

    public String colourise() {
        return ChatColor.translateAlternateColorCodes('&', this.string);
    }

    public String colourise(char c) {
        return ChatColor.translateAlternateColorCodes(c, this.string);
    }

    public String[] split(String regex) {
        return this.string.split(regex);
    }

    @Override
    public String toString() {
        return this.string;
    }

    private SString replacer(String value, String replacement, boolean ignoreCase) {

        if (string == null) {
            return null;
        }

        if (value == null || value.length() == 0) {
            return this;
        }

        if (value.length() > string.length()) {
            return this;
        }

        int counter = 0;
        String subString;
        while ((counter < string.length())
                && (string.substring(counter).length() >= value.length())) {
            subString = string.substring(counter, counter + value.length());
            if (ignoreCase) {
                if (subString.equalsIgnoreCase(value)) {
                    string = string.substring(0, counter) + replacement
                            + string.substring(counter + value.length());
                    counter += replacement.length();
                } else {
                    counter++; // No match so move on to the next character from
                }
            } else {
                if (subString.equals(value)) {
                    string = string.substring(0, counter) + replacement
                            + string.substring(counter + value.length());
                    counter += replacement.length();
                } else {
                    counter++;
                }
            }
        }
        return this;
    }

    public SString format(Object... args) {
        string = String.format(string, args);
        return this;
    }

    public SString replaceLast(String value, String replacement) {
        int pos = string.lastIndexOf(value);
        if (pos > -1) {
            string = string.substring(0, pos)
                    + replacement
                    + string.substring(pos + value.length());
        }
        return this;
    }

}

