package me.fullpage.core.objects;

import lombok.Getter;
import lombok.Setter;
import lombok.SneakyThrows;
import org.bukkit.plugin.Plugin;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@Getter
@Setter
public class UserMap {

    private final Plugin plugin;
    private final File userMapFile;

    public UserMap(Plugin plugin) {
        this.plugin = plugin;
        this.userMapFile = new File(plugin.getServer().getWorldContainer(), "fullpage_core_usermap.csv");
        if (!userMapFile.exists()) {
            try {
                userMapFile.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SneakyThrows
    public UUID getUUID(String name) {
        BufferedReader csvReader = new BufferedReader(new FileReader(userMapFile));
        String row;
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            final String userName = data[0];
            if (userName == null) {
                continue;
            }
            final String stringUUID = data[1];
            if (stringUUID == null) {
                continue;
            }
            final UUID uuid = UUID.fromString(stringUUID);

            if (userName.equalsIgnoreCase(name)) {
                csvReader.close();
                return uuid;
            }
        }
        csvReader.close();
        return null;
    }

    @SneakyThrows
    public String getNameFromUUID(String uniqueId) {
        BufferedReader csvReader = new BufferedReader(new FileReader(userMapFile));
        String row;
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            final String userName = data[0];
            if (userName == null) {
                continue;
            }
            final String stringUUID = data[1];
            if (stringUUID == null) {
                continue;
            }

            if (stringUUID.equals(uniqueId.toString())) {
                csvReader.close();
                return userName;
            }
        }
        csvReader.close();
        return null;
    }

    @SneakyThrows
    public HashMap<String, UUID> read() {
        HashMap<String, UUID> userNameUUID = new HashMap<>();
        BufferedReader csvReader = new BufferedReader(new FileReader(userMapFile));
        String row;
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            final String userName = data[0];
            if (userName == null) {
                continue;
            }
            final String stringUUID = data[1];
            if (stringUUID == null) {
                continue;
            }
            final UUID uuid = UUID.fromString(stringUUID);

            userNameUUID.put(userName, uuid);
        }
        csvReader.close();
        return userNameUUID;
    }

    @SneakyThrows
    public void remove(String username) {
        BufferedReader csvReader = new BufferedReader(new FileReader(userMapFile));
        String row;
        List<String> fileContents = new ArrayList<String>();
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            final String userName = data[0];
            if (userName == null) {
                continue;
            }
            if (userName.equalsIgnoreCase(username)) {
                continue;
            }
            fileContents.add(row);
        }
        csvReader.close();
        BufferedWriter bw = null;
        try {
            FileWriter fw = new FileWriter(userMapFile, false);
            bw = new BufferedWriter(fw);
            for (String s : fileContents) {
                bw.write(s);
                bw.newLine();
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            if (bw != null)
                bw.close();
        }
    }

    @SneakyThrows
    public void remove(UUID uniqueId) {
        BufferedReader csvReader = new BufferedReader(new FileReader(userMapFile));
        String row;
        List<String> fileContents = new ArrayList<>();
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            if (data.length < 2) {
                continue;
            }
            final String uuid = data[1];
            if (uuid == null) {
                continue;
            }
            if (uuid.equalsIgnoreCase(uniqueId.toString())) {
                continue;
            }
            fileContents.add(row);
        }
        csvReader.close();
        BufferedWriter bw = null;
        try {
            FileWriter fw = new FileWriter(userMapFile, false);
            bw = new BufferedWriter(fw);
            for (String s : fileContents) {
                bw.write(s);
                bw.newLine();
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            if (bw != null)
                bw.close();
        }
    }

    @SneakyThrows
    public void add(String userName, UUID uuid) {
        BufferedWriter bw = null;
        try {
            FileWriter fw = new FileWriter(userMapFile, true);
            bw = new BufferedWriter(fw);
            bw.write(userName + "," + uuid);
            bw.newLine();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            if (bw != null)
                bw.close();
        }
    }


}
