package me.fullpage.core.listeners;

import me.fullpage.core.api.events.PlayerChunkMoveEvent;
import me.fullpage.core.utilities.Utils;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener extends FListener {

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        final Player player = event.getPlayer();
        final Location to = event.getTo();
        if (to == null) {
            return;
        }
        final Location from = event.getFrom();

        final World world = from.getWorld();
        if (world == null) {
            return;
        }

        int toChunkX = Utils.floor(to.getBlockX()) >> 4;
        int toChunkZ = Utils.floor(to.getBlockZ()) >> 4;
        int fromChunkX = Utils.floor(from.getBlockX()) >> 4;
        int fromChunkZ = Utils.floor(from.getBlockZ()) >> 4;

        if (toChunkX == fromChunkX && toChunkZ == fromChunkZ) {
            return;
        }

        final Chunk toFChunk = world.getChunkAt(toChunkX, toChunkZ);
        final Chunk fromFChunk = world.getChunkAt(fromChunkX, fromChunkZ);

        final PlayerChunkMoveEvent playerChunkMoveEvent = new PlayerChunkMoveEvent(player, toFChunk, fromFChunk);

        getCore().getPlugin().getServer().getPluginManager().callEvent(playerChunkMoveEvent);

        if (playerChunkMoveEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

}
