package me.fullpage.core.listeners;

import me.fullpage.core.api.events.armourequipevent.ArmourEquipEvent;
import me.fullpage.core.api.events.armourequipevent.ArmourType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockDispenseArmorEvent;

public class DispenserArmorListener extends FListener {


    @EventHandler
    public void dispenseArmorEvent(BlockDispenseArmorEvent event) {
        ArmourType type = ArmourType.matchType(event.getItem());
        if (type != null) {
            if (event.getTargetEntity() instanceof Player) {
                Player p = (Player) event.getTargetEntity();
                ArmourEquipEvent armorEquipEvent = new ArmourEquipEvent(p, ArmourEquipEvent.EquipMethod.DISPENSER, type, null, event.getItem());
                getCore().getPlugin().getServer().getPluginManager().callEvent(armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    event.setCancelled(true);
                }
            }
        }
    }
}