package me.fullpage.core.data.json;

import me.fullpage.core.FullpageCorePlugin;
import me.fullpage.core.data.ConfigManager;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JsonConfiguration {

    /**
     * An instance of the Main Class
     */
    private final Plugin plugin = FullpageCorePlugin.getCore().getPlugin();

    /**
     * The name of the file you are working with
     */
    private final String fileName;

    /**
     * The File in which the file is apart of
     */
    private final File configFile;

    public File getConfigFile() {
        return configFile;
    }

    public JsonConfiguration(String fileName, boolean createFile) {
        this.fileName = fileName;
        File dataFolder = plugin.getDataFolder();
        if (dataFolder == null)
            throw new IllegalStateException();
        this.configFile = new File(plugin.getDataFolder(), fileName);
        if (createFile && !configFile.exists()) {
            configFile.getParentFile().mkdirs();
            try {
                configFile.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else if (!configFile.exists()) {
            new ConfigManager(fileName).saveDefaultConfig();
        }
    }

    public Map<?, ?> readFile() throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        if (getConfigFile().length() < 1)
            return new HashMap<>();
        return (JSONObject) parser.parse(new FileReader(getConfigFile()));
    }


}
