package me.fullpage.core.data;

import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractData {

    public ConfigManager dataConfig;
    public FileConfiguration data;

    private final Plugin plugin;
    private final String fileName;
    private final long savePeriod;
    private final TimeUnit timeUnit;
    private final Map map; //todo support other maps

    public AbstractData(Plugin plugin, String fileName, long savePeriod, TimeUnit timeUnit, Map map) {
        this.plugin = plugin;
        this.fileName = "data/" + fileName;
        this.savePeriod = savePeriod;
        this.timeUnit = timeUnit;
        this.map = map;
        this.dataConfig = new ConfigManager(fileName);
        this.data = dataConfig.getConfig();
    }

    public Map getMap() {
        return map;
    }


    public Plugin getPlugin() {
        return plugin;
    }

    public ConfigManager getConfigManager() {
        return dataConfig;
    }

    public FileConfiguration getConfig() {
        return data;
    }

    public String getFileName() {
        return fileName;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    public long getSavePeriod() {
        return savePeriod;
    }

    public abstract void init() throws IOException;

    public abstract void saveData();

    public void loopSaveData() {
        final long period = convertTime(savePeriod, timeUnit, TimeUnit.SECONDS) * 20;
        Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, this::saveData, period, period);
    }


    private long convertTime(long duration, TimeUnit before, TimeUnit after) {
        return after.convert(duration, before);
    }

}
