package me.fullpage.core.data;

import lombok.Getter;
import lombok.Setter;
import me.fullpage.core.data.json.JsonConfiguration;
import me.fullpage.core.data.json.JsonFormatter;

import java.io.FileWriter;
import java.io.IOException;

@Getter
@Setter
public abstract class AbstractCache {

    private final JsonConfiguration config;

    public AbstractCache(String fileName) {
        config = new JsonConfiguration("data/cache/" + fileName, true);
    }

    public abstract String build();

    public void save(String jsonString) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(config.getConfigFile(), false);
            fileWriter.write(JsonFormatter.format(jsonString, 2));
        } catch (IOException e) {
            e.printStackTrace();
        } finally {

            try {
                fileWriter.flush();
                fileWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        try {
            new FileWriter(config.getConfigFile(), false).close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
