package me.fullpage.core.api.interfaces;

public interface Economy {

    /**
     * @return if the player has a wallet
     */
    boolean hasWallet();

    /**
     * @return if a wallet has been made
     */
    boolean createWallet();

    /**
     * @return balance of a player
     */
    long getBalance();

    /**
     * @param amountNeeded is the minimum amount the player's balance must be to return true
     * @return whether the account balance is >= the amountNeeded
     */
    boolean hasEnoughBalance(long amountNeeded);

    /**
     * @param target is the account that is receiving the money
     * @param amount is the amount that is being sent
     * @return true if the player hasEnoughBalance, otherwise false
     */
    boolean payBalance(Economy target, long amount);

    /**
     * @param amount is the amount that will be added to this account
     */
    void addBalance(long amount);

    /**
     * @param amount is the amount that will removed from this account
     */
    void removeBalance(long amount);

    /**
     * @param amount is the amount that the balance will be set to
     */
    void setBalance(long amount);

    /**
     * balance will be set to 0
     */
    void resetBalance();

}
