package me.fullpage.core;

import lombok.Getter;
import lombok.SneakyThrows;
import me.fullpage.core.api.FullpageCoreAPI;
import me.fullpage.core.api.NMSHandler;
import me.fullpage.core.v1_12_r1.NMSHandler_1_12_R1;
import me.fullpage.core.v1_13_r2.NMSHandler_1_13_R2;
import me.fullpage.core.v1_14_r1.NMSHandler_1_14_R1;
import me.fullpage.core.v1_16_r3.NMSHandler_1_16_R3;
import me.fullpage.core.v1_17_r1.NMSHandler_1_17_R1;
import me.fullpage.core.v1_8_r3.NMSHandler_1_8_R3;
import me.fullpage.core.data.ConfigManager;
import me.fullpage.core.listeners.ArmourListener;
import me.fullpage.core.listeners.DispenserArmorListener;
import me.fullpage.core.listeners.PlayerMoveListener;
import org.bukkit.Bukkit;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;

@Getter
public abstract class FullpageCore implements FullpageCoreAPI {
    private String nmsVersion;
    private NMSHandler nmsHandler;

    private final Plugin plugin;
    private static FullpageCore core;
    private static SimpleCommandMap scm;

    public static FullpageCore getCore() {
        return core;
    }


    public FullpageCore(Plugin plugin) {
        this.plugin = plugin;
        start();
    }

    public abstract void registerCommands(SimpleCommandMap scm);

    @SneakyThrows
    private void start() {
        core = this;
        nmsVersion = getNMSVersion();
        if (!enableNMSHandler()) {
            plugin.getPluginLoader().disablePlugin(plugin);
            return;
        }
        final ConfigManager configManager = new ConfigManager("blocked.yml");

        new PlayerMoveListener();
        log(Level.INFO, "Registered PlayerChunkMoveEvent");
        new ArmourListener(configManager.getConfig().getStringList("blocked"));
        log(Level.INFO, "Registered ArmourEquipEvent");
        try {
            Class.forName("org.bukkit.event.block.BlockDispenseArmorEvent");
            new DispenserArmorListener();
        } catch (Exception ignored) {
        }

        setupSimpleCommandMap();
        registerCommands(scm);

    }

    public static final String[] supportedVersions = {"v1_8_R3", "v1_12_R1", "v1_13_R2", "v1_14_R1", "v1_16_R3", "v1_17_R1"};

    @Override
    public boolean enableNMSHandler() {
        log(Level.SEVERE, "Found server version " + nmsVersion);

        if (Arrays.stream(supportedVersions).anyMatch(s -> s.equalsIgnoreCase(nmsVersion))) {
            switch (nmsVersion) {
                case "v1_8_R3":
                    nmsHandler = new NMSHandler_1_8_R3(this);
                    break;
                case "v1_12_R1":
                    nmsHandler = new NMSHandler_1_12_R1(this);
                    break;
                case "v1_13_R2":
                    nmsHandler = new NMSHandler_1_13_R2(this);
                    break;
                case "v1_14_R1":
                    nmsHandler = new NMSHandler_1_14_R1(this);
                    break;
                case "v1_16_R3":
                    nmsHandler = new NMSHandler_1_16_R3(this);
                    break;
                case "v1_17_R1":
                    nmsHandler = new NMSHandler_1_17_R1(this);
                    break;
                default:
                    log(Level.SEVERE, "Your server version (" + nmsVersion + ") is not supported!");
                    log(Level.SEVERE, "Disabling Plugin (Failure to register NMS Handler)!");
                    return false;
            }
        } else {
            log(Level.SEVERE, "Your server version (" + nmsVersion + ") is not supported!");
            log(Level.SEVERE, "Disabling Plugin (Failure to register NMS Handler)!");
            return false;
        }

        log(Level.INFO, "Enabled NMS handler!");

        return true;
    }

    @Override
    public String getNMSVersion() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().split(Pattern.quote("."))[3];
        } catch (Exception ex) {
            return "UNKNOWN";
        }
        return version;
    }

    @Override
    public NMSHandler getNMSHandler() {
        return nmsHandler;
    }

    public static void log(Level level, String message) {
        System.out.println(String.format("[%s] [%s]: %s", level.getName(), "FullpageCore", message));
    }


    public File getCoreFolder() {
        return new File(plugin.getDataFolder().getAbsolutePath().replace(plugin.getName(), "FullpageCorePlugin"));
    } private void setupSimpleCommandMap() {
        SimplePluginManager spm = (SimplePluginManager) plugin.getServer().getPluginManager();
        Field f = null;
        try {
            f = SimplePluginManager.class.getDeclaredField("commandMap");
        } catch (Exception e) {
            e.printStackTrace();
        }
        assert f != null;
        f.setAccessible(true);
        try {
            scm = (SimpleCommandMap) f.get(spm);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void register(FullpageCommand command) {
        scm.register("/", command);
    }

    public void register(FullpageCommand... command) {
        Arrays.stream(command).forEach(cmd -> scm.register("/", cmd));
    }


}
