package me.fullpage.tvouchers.commands;

import de.tr7zw.fullpage.nbtapi.NBTItem;
import me.fullpage.core.FullpageCommand;
import me.fullpage.tvouchers.data.Config;
import me.fullpage.tvouchers.data.ConfigManager;
import me.fullpage.tvouchers.managers.Voucher;
import me.fullpage.tvouchers.utilities.CM;
import me.fullpage.tvouchers.utilities.Permissions;
import me.fullpage.tvouchers.utilities.SString;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginDescriptionFile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class VoucherCmd extends FullpageCommand {

    public VoucherCmd() {
        super("voucher", Permissions.VOUCHER_GIVE.getPermission());
        setAliases(Arrays.asList("vouchers", "tvoucher", "tvouchers"));
        setUsage("/voucher give <player> <type> <amount>");
        setDescription("Give a player a voucher!");
    }

    @Override
    public void run(CommandSender sender, String command, String[] args) {

        if (args.length >= 1 && args[0].toLowerCase().startsWith("nbt") && sender instanceof Player) {
            ItemStack hand = ((Player) sender).getItemInHand();
            if (hand == null || hand.getType().equals(Material.AIR) || hand.getAmount() == 0) {
                sendMessage("&cYou must be holding an item in your hand!");
                return;
            } else if (!hand.hasItemMeta() || hand.getItemMeta() == null) {
                sendMessage("&cThis item has no meta data!");
                return;
            }
            NBTItem nbtItem = new NBTItem(hand);
            sender.sendMessage(nbtItem.asNBTString().replace("§", "&"));

            return;
        } else if (args.length == 1 && args[0].toLowerCase().startsWith("v")) {
            PluginDescriptionFile pdf = getCore().getPlugin().getDescription();
            sendMessage("&6_________.[ &2Plugin Version & Information &6].________",
                    "&dName:&b " + pdf.getName(),
                    "&dVersion:&b " + pdf.getVersion(),
                    "&dAuthors: &b" + String.join(", ", pdf.getAuthors()),
                    "&dDescription: &b" + pdf.getDescription());
            return;
        } else if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
            sendMessage("&6______.[ &2Voucher List &6].______");
            sendMessage(ChatColor.YELLOW + String.join(", ", Voucher.getVouchersList()));
            return;
        } else if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission(Permissions.RELOAD.getPermission())) {
                sendNoPermissionMessage();
                return;
            }
            ConfigManager configManager = new ConfigManager("config.yml");
            ConfigManager voucherManager = new ConfigManager("voucher.yml");
            ConfigManager guiManager = new ConfigManager("gui.yml");
            configManager.reloadConfig();
            voucherManager.reloadConfig();
            guiManager.reloadConfig();
            Config.voucher = voucherManager.getConfig();
            Config.config = configManager.getConfig();
            Config.gui = guiManager.getConfig();
            configManager.saveConfig();
            voucherManager.saveConfig();
            guiManager.saveConfig();
            //redefine every manager in "class"
            Config.loadConfig();
            Voucher.loadVouchers();
            sendMessage("&aPlugin has successfully been reloaded.");
            return;
        }

        if (args.length <= 1) {
sendUsageMessage();
            return;
        }

        Player player = Bukkit.getPlayer(args[1]);
        if (player == null) {
            sendMessage("&cCannot find that player, please try again.");
            return;
        }

        if (args.length == 2 || !Voucher.voucherFromName(args[2])) {
            sendMessage("&cPlease enter a valid voucher type.");
            return;
        }

        int amount = 1;
        if (args.length == 4) {
            try {
                amount = Integer.parseInt(args[3]);
            } catch (Exception e) {
                //tandle
            }
        }

        if (amount < 1)
            amount = 1;


        Voucher voucher = Voucher.getVouchers().get(args[2]);
        ItemStack item = voucher.getNbtItem().getItem();
        item.setAmount(amount);

        player.getInventory().addItem(item);
        player.sendMessage(CM.colourStr(new SString(Config.RECEIVED_VOUCHER).replaceIgnoreCase("{AMOUNT}", amount + "").replaceIgnoreCase("{PLAYER}", player.getName()).replaceIgnoreCase("{VOUCHER}", voucher.getVoucherName().toUpperCase()).get()));
        sender.sendMessage(CM.colourStr(new SString("&aYou have given {PLAYER} {AMOUNT}x {VOUCHER} vouchers!").replaceIgnoreCase("{AMOUNT}", amount + "").replaceIgnoreCase("{PLAYER}", player.getName()).replaceIgnoreCase("{VOUCHER}", voucher.getVoucherName().toUpperCase()).get()));


    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (!sender.hasPermission(Permissions.VOUCHER_GIVE.getPermission())) {
            return null;
        }
        if (args.length == 1) {
            return Arrays.asList("give", "reload", "list", "nbtinfo", "version");
        } else if (args.length == 2) {
            return super.tabComplete(sender, alias, args);
        } else if (args.length == 3) {
            if (args[2].isEmpty())
                return new ArrayList<>(Voucher.getVouchersList());
            else
                return Voucher.getVouchersList().stream().map(String::toLowerCase)
                        .filter(x -> x.startsWith(args[2].toLowerCase()))
                        .collect(Collectors.toList());
        } else if (args.length == 4) {
            return Arrays.asList("1", "2", "3", "4", "5", "8", "16", "32", "48", "64");
        }
        return null;
    }
}
