package me.fullpage.tvouchers;

import me.fullpage.core.FullpageCore;
import me.fullpage.tvouchers.commands.VoucherCmd;
import me.fullpage.tvouchers.data.Config;
import me.fullpage.tvouchers.data.Data;
import me.fullpage.tvouchers.listeners.VoucherListener;
import me.fullpage.tvouchers.managers.Base;
import me.fullpage.tvouchers.managers.GUI;
import me.fullpage.tvouchers.managers.Voucher;
import me.fullpage.tvouchers.utilities.RandomString;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public final class TVouchers extends JavaPlugin {

    private static Plugin instance;

    public static Plugin getInstance() {
        return instance;
    }

    private static final ThreadLocalRandom rand = ThreadLocalRandom.current();

    public static ThreadLocalRandom getRand() {
        return rand;
    }

    private static final RandomString randomString = new RandomString(8, new SecureRandom());

    public static RandomString getRandomString() {
        return randomString;
    }

    @Override
    public void onEnable() {
        instance = this;
        new FullpageCore(this) {
            @Override
            public void registerCommands(SimpleCommandMap simpleCommandMap) {
                register(new VoucherCmd());
            }
        };
        Config.loadConfig();
        Config.loadIdentifier();
        registerListeners(new VoucherListener());
        Voucher.loadVouchers();
        Data.loopSaveData();
        GUI.loadDefault();
    }

    @Override
    public void onDisable() {
        Base.disable(this);
        Data.saveData();
    }

    private void registerListeners(Listener... listeners) {
        Arrays.stream(listeners).forEach(listener -> getServer().getPluginManager().registerEvents(listener, this));
    }

}
