/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.api.world.properties;

import com.flowpowered.nbt.ByteTag;
import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.flowpowered.nbt.IntTag;
import com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.api.world.properties.PropertyType;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimeProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SlimePropertyMap {
    private final Map<SlimeProperty, Object> values;

    public SlimePropertyMap() {
        this(new HashMap<SlimeProperty, Object>());
    }

    public String getString(SlimeProperty property) {
        this.ensureType(property, PropertyType.STRING);
        String value = (String)this.values.get(property);
        if (value == null) {
            value = (String)property.getDefaultValue();
        }
        return value;
    }

    public void setString(SlimeProperty property, String value) {
        Objects.requireNonNull(value, "Property value cannot be null");
        this.ensureType(property, PropertyType.STRING);
        if (property.getValidator() != null && !property.getValidator().apply(value).booleanValue()) {
            throw new IllegalArgumentException("'" + value + "' is not a valid property value.");
        }
        this.values.put(property, value);
    }

    public Boolean getBoolean(SlimeProperty property) {
        this.ensureType(property, PropertyType.BOOLEAN);
        Boolean value = (Boolean)this.values.get(property);
        if (value == null) {
            value = (Boolean)property.getDefaultValue();
        }
        return value;
    }

    public void setBoolean(SlimeProperty property, boolean value) {
        this.ensureType(property, PropertyType.BOOLEAN);
        this.values.put(property, value);
    }

    public int getInt(SlimeProperty property) {
        this.ensureType(property, PropertyType.INT);
        Integer value = (Integer)this.values.get(property);
        if (value == null) {
            value = (Integer)property.getDefaultValue();
        }
        return value;
    }

    public void setInt(SlimeProperty property, int value) {
        this.ensureType(property, PropertyType.INT);
        if (property.getValidator() != null && !property.getValidator().apply(value).booleanValue()) {
            throw new IllegalArgumentException("'" + value + "' is not a valid property value.");
        }
        this.values.put(property, value);
    }

    private void ensureType(SlimeProperty property, PropertyType requiredType) {
        if (property.getType() != requiredType) {
            throw new IllegalArgumentException("Property " + property.getNbtName() + " type is " + property.getType().name() + ", not " + requiredType.name());
        }
    }

    public void merge(SlimePropertyMap propertyMap) {
        this.values.putAll(propertyMap.getValues());
    }

    public CompoundTag toCompound() {
        CompoundMap map = new CompoundMap();
        for (Map.Entry<SlimeProperty, Object> entry : this.values.entrySet()) {
            SlimeProperty property = entry.getKey();
            Object value = entry.getValue();
            switch (property.getType()) {
                case STRING: {
                    map.put(property.getNbtName(), new StringTag(property.getNbtName(), (String)value));
                    break;
                }
                case BOOLEAN: {
                    map.put(property.getNbtName(), new ByteTag(property.getNbtName(), (byte)((Boolean)value != false ? 1 : 0)));
                    break;
                }
                case INT: {
                    map.put(property.getNbtName(), new IntTag(property.getNbtName(), (Integer)value));
                }
            }
        }
        return new CompoundTag("properties", map);
    }

    public static SlimePropertyMap fromCompound(CompoundTag compound) {
        HashMap<SlimeProperty, Object> values = new HashMap<SlimeProperty, Object>();
        block5: for (SlimeProperty property : SlimeProperties.VALUES) {
            switch (property.getType()) {
                case STRING: {
                    compound.getStringValue(property.getNbtName()).ifPresent(value -> values.put(property, value));
                    continue block5;
                }
                case BOOLEAN: {
                    compound.getByteValue(property.getNbtName()).map(value -> value == 1).ifPresent(value -> values.put(property, value));
                    continue block5;
                }
                case INT: {
                    compound.getIntValue(property.getNbtName()).ifPresent(value -> values.put(property, value));
                }
            }
        }
        return new SlimePropertyMap(values);
    }

    private SlimePropertyMap(Map<SlimeProperty, Object> values) {
        this.values = values;
    }

    private Map<SlimeProperty, Object> getValues() {
        return this.values;
    }
}

