/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.api.world;

import com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.api.exceptions.WorldAlreadyExistsException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import java.io.IOException;
import java.util.Collection;

public interface SlimeWorld {
    public String getName();

    public SlimeLoader getLoader();

    public SlimeChunk getChunk(int var1, int var2);

    public CompoundTag getExtraData();

    public Collection<CompoundTag> getWorldMaps();

    @Deprecated
    public SlimeProperties getProperties();

    public SlimePropertyMap getPropertyMap();

    public boolean isReadOnly();

    public SlimeWorld clone(String var1);

    public SlimeWorld clone(String var1, SlimeLoader var2) throws WorldAlreadyExistsException, IOException;

    public SlimeWorld clone(String var1, SlimeLoader var2, boolean var3) throws WorldAlreadyExistsException, IOException;

    public boolean isLocked();

    @Deprecated
    public static class SlimeProperties {
        private double spawnX;
        private double spawnY;
        private double spawnZ;
        private int difficulty;
        private boolean allowMonsters;
        private boolean allowAnimals;
        private boolean readOnly;
        private boolean pvp;
        private String environment;

        private static double $default$spawnY() {
            return 255.0;
        }

        private static boolean $default$allowMonsters() {
            return true;
        }

        private static boolean $default$allowAnimals() {
            return true;
        }

        private static boolean $default$pvp() {
            return true;
        }

        private static String $default$environment() {
            return "NORMAL";
        }

        SlimeProperties(double spawnX, double spawnY, double spawnZ, int difficulty, boolean allowMonsters, boolean allowAnimals, boolean readOnly, boolean pvp, String environment) {
            this.spawnX = spawnX;
            this.spawnY = spawnY;
            this.spawnZ = spawnZ;
            this.difficulty = difficulty;
            this.allowMonsters = allowMonsters;
            this.allowAnimals = allowAnimals;
            this.readOnly = readOnly;
            this.pvp = pvp;
            this.environment = environment;
        }

        public static SlimePropertiesBuilder builder() {
            return new SlimePropertiesBuilder();
        }

        public SlimePropertiesBuilder toBuilder() {
            return new SlimePropertiesBuilder().spawnX(this.spawnX).spawnY(this.spawnY).spawnZ(this.spawnZ).difficulty(this.difficulty).allowMonsters(this.allowMonsters).allowAnimals(this.allowAnimals).readOnly(this.readOnly).pvp(this.pvp).environment(this.environment);
        }

        public double getSpawnX() {
            return this.spawnX;
        }

        public double getSpawnY() {
            return this.spawnY;
        }

        public double getSpawnZ() {
            return this.spawnZ;
        }

        public int getDifficulty() {
            return this.difficulty;
        }

        public boolean allowMonsters() {
            return this.allowMonsters;
        }

        public boolean allowAnimals() {
            return this.allowAnimals;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isPvp() {
            return this.pvp;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public SlimeProperties withReadOnly(boolean readOnly) {
            return this.readOnly == readOnly ? this : new SlimeProperties(this.spawnX, this.spawnY, this.spawnZ, this.difficulty, this.allowMonsters, this.allowAnimals, readOnly, this.pvp, this.environment);
        }

        public static class SlimePropertiesBuilder {
            private double spawnX;
            private boolean spawnY$set;
            private double spawnY;
            private double spawnZ;
            private int difficulty;
            private boolean allowMonsters$set;
            private boolean allowMonsters;
            private boolean allowAnimals$set;
            private boolean allowAnimals;
            private boolean readOnly;
            private boolean pvp$set;
            private boolean pvp;
            private boolean environment$set;
            private String environment;

            SlimePropertiesBuilder() {
            }

            public SlimePropertiesBuilder spawnX(double spawnX) {
                this.spawnX = spawnX;
                return this;
            }

            public SlimePropertiesBuilder spawnY(double spawnY) {
                this.spawnY = spawnY;
                this.spawnY$set = true;
                return this;
            }

            public SlimePropertiesBuilder spawnZ(double spawnZ) {
                this.spawnZ = spawnZ;
                return this;
            }

            public SlimePropertiesBuilder difficulty(int difficulty) {
                this.difficulty = difficulty;
                return this;
            }

            public SlimePropertiesBuilder allowMonsters(boolean allowMonsters) {
                this.allowMonsters = allowMonsters;
                this.allowMonsters$set = true;
                return this;
            }

            public SlimePropertiesBuilder allowAnimals(boolean allowAnimals) {
                this.allowAnimals = allowAnimals;
                this.allowAnimals$set = true;
                return this;
            }

            public SlimePropertiesBuilder readOnly(boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public SlimePropertiesBuilder pvp(boolean pvp) {
                this.pvp = pvp;
                this.pvp$set = true;
                return this;
            }

            public SlimePropertiesBuilder environment(String environment) {
                this.environment = environment;
                this.environment$set = true;
                return this;
            }

            public SlimeProperties build() {
                double spawnY = this.spawnY;
                if (!this.spawnY$set) {
                    spawnY = SlimeProperties.$default$spawnY();
                }
                boolean allowMonsters = this.allowMonsters;
                if (!this.allowMonsters$set) {
                    allowMonsters = SlimeProperties.$default$allowMonsters();
                }
                boolean allowAnimals = this.allowAnimals;
                if (!this.allowAnimals$set) {
                    allowAnimals = SlimeProperties.$default$allowAnimals();
                }
                boolean pvp = this.pvp;
                if (!this.pvp$set) {
                    pvp = SlimeProperties.$default$pvp();
                }
                String environment = this.environment;
                if (!this.environment$set) {
                    environment = SlimeProperties.$default$environment();
                }
                return new SlimeProperties(this.spawnX, spawnY, this.spawnZ, this.difficulty, allowMonsters, allowAnimals, this.readOnly, pvp, environment);
            }

            public String toString() {
                return "SlimeWorld.SlimeProperties.SlimePropertiesBuilder(spawnX=" + this.spawnX + ", spawnY=" + this.spawnY + ", spawnZ=" + this.spawnZ + ", difficulty=" + this.difficulty + ", allowMonsters=" + this.allowMonsters + ", allowAnimals=" + this.allowAnimals + ", readOnly=" + this.readOnly + ", pvp=" + this.pvp + ", environment=" + this.environment + ")";
            }
        }
    }
}

