/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class UpdateChecker {
    private final PluginDescriptionFile description;
    private static final String RESOURCE_ID = InnovativeItems.isPluginPremium() ? "93570" : "96456";

    public UpdateChecker(@NotNull Plugin plugin) {
        this.description = plugin.getDescription();
    }

    public void checkForUpdates() {
        String newestVersion;
        String currentVersion = this.description.getVersion();
        if (currentVersion.equals(newestVersion = UpdateChecker.getNewestVersion())) {
            LogUtil.logUnblocked(LogUtil.Level.INFO, "You are currently running the newest version of the plugin!");
            return;
        }
        LogUtil.logUnblocked(LogUtil.Level.INFO, "You are currently running an outdated version of this plugin. You are currently on version " + currentVersion + ", while the newest version is version " + newestVersion + "!");
    }

    public static String getNewestVersion() {
        InputStream input;
        try {
            input = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + RESOURCE_ID).openStream();
        }
        catch (IOException e) {
            LogUtil.log(LogUtil.Level.SEVERE, "There was an issue while trying to make an api call to spigot's version api! Please contact the developer of the plugin!");
            e.printStackTrace();
            return null;
        }
        Scanner scanner = new Scanner(input);
        String version = scanner.hasNext() ? scanner.next() : null;
        scanner.close();
        return version;
    }
}

