/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RevisedEquipmentSlot {
    HEAD(EquipmentSlot.HEAD),
    CHEST(EquipmentSlot.CHEST),
    LEGS(EquipmentSlot.LEGS),
    FEET(EquipmentSlot.FEET),
    HAND(EquipmentSlot.HAND),
    OFF_HAND(EquipmentSlot.OFF_HAND),
    ANY(null);

    private final EquipmentSlot slot;

    private RevisedEquipmentSlot(EquipmentSlot slot) {
        this.slot = slot;
    }

    @Nullable
    public EquipmentSlot getSlot() {
        return this.slot;
    }

    @NotNull
    public ItemStack[] getFromPlayer(@NotNull Player player) {
        if (this != ANY) {
            return new ItemStack[]{player.getInventory().getItem(this.slot)};
        }
        ItemStack[] array = new ItemStack[6];
        RevisedEquipmentSlot[] values = RevisedEquipmentSlot.values();
        for (int i = 0; i < values.length - 1; ++i) {
            array[i] = player.getInventory().getItem(values[i].getSlot());
        }
        return array;
    }

    @Nullable
    public static RevisedEquipmentSlot getFromSlot(@NotNull EquipmentSlot slot) {
        for (RevisedEquipmentSlot equipmentSlot : RevisedEquipmentSlot.values()) {
            if (!slot.name().equals(equipmentSlot.name())) continue;
            return equipmentSlot;
        }
        return null;
    }
}

