/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResponseUtil {
    private static final Map<UUID, UserResponse> RESPONDING = new HashMap<UUID, UserResponse>();
    private static boolean enabled = false;

    private ResponseUtil() {
    }

    public static void enable() {
        if (!enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)InnovativeItems.getInstance());
            enabled = true;
        }
    }

    public static boolean input(@Nullable String prompt, @NotNull Player to, @NotNull UserResponse response) {
        if (RESPONDING.containsKey(to.getUniqueId())) {
            return false;
        }
        if (prompt != null && !prompt.isEmpty()) {
            TextUtil.sendMessage((CommandSender)to, prompt);
        } else if (prompt == null) {
            TextUtil.sendMessage((CommandSender)to, "&rPlease type your response in chat. Type &r&ccancel&r to end the prompt.");
        }
        RESPONDING.put(to.getUniqueId(), response);
        return true;
    }

    public static boolean input(@NotNull Player to, @NotNull UserResponse response) {
        return ResponseUtil.input(null, to, response);
    }

    private static class ChatListener
    implements Listener {
        private ChatListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        private void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
            if (!RESPONDING.containsKey(event.getPlayer().getUniqueId())) {
                return;
            }
            UserResponse response = (UserResponse)RESPONDING.remove(event.getPlayer().getUniqueId());
            String message = event.getMessage();
            Bukkit.getScheduler().runTask((Plugin)InnovativeItems.getInstance(), () -> response.response(message.equalsIgnoreCase("cancel") ? null : message));
            event.setCancelled(true);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        private void onPlayerQuit(PlayerQuitEvent event) {
            UserResponse response = (UserResponse)RESPONDING.remove(event.getPlayer().getUniqueId());
            if (response != null) {
                response.response(null);
            }
        }
    }

    @FunctionalInterface
    public static interface UserResponse {
        public void response(@Nullable String var1);
    }
}

