/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class RegexUtil {
    private RegexUtil() {
    }

    @NotNull
    private static String literalWithEscape(@NotNull String literal) {
        return "(?<!\\\\)\\" + literal;
    }

    @NotNull
    public static String[] splitLiteralWithEscape(@NotNull String text, @NotNull String literal) {
        return RegexUtil.splitLiteralWithEscape(text, literal, 0);
    }

    @NotNull
    public static String[] splitLiteralWithEscape(@NotNull String text, @NotNull String literal, int limit) {
        String regex = RegexUtil.literalWithEscape(literal);
        String[] split = text.split(regex, limit);
        return (String[])Arrays.stream(split).map(value -> value.replace("\\" + literal, literal)).toArray(String[]::new);
    }

    @NotNull
    public static String replaceLiteralWithEscape(@NotNull String text, @NotNull String replace, @NotNull String literal) {
        String regex = RegexUtil.literalWithEscape(literal);
        return text.replaceAll(regex, replace).replace("\\" + literal, literal);
    }
}

