/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.functions.FunctionContext;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.keyword.Keyword;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogUtil {
    private LogUtil() {
    }

    public static void log(@NotNull Level level, @NotNull String text) {
        if (level == Level.NOTHING) {
            return;
        }
        int debugLevel = InnovativeItems.getInstance().getConfigManager().getDebugLevel();
        if (level == Level.NOISE && debugLevel < Level.NOISE.getDebugLevel()) {
            return;
        }
        if (level == Level.DEV && debugLevel < Level.DEV.getDebugLevel()) {
            return;
        }
        if (level == Level.INFO && debugLevel < Level.INFO.getDebugLevel()) {
            return;
        }
        if (level == Level.WARNING && debugLevel < Level.WARNING.getDebugLevel()) {
            return;
        }
        if (level == Level.SEVERE && debugLevel < Level.SEVERE.getDebugLevel()) {
            return;
        }
        LogUtil.logUnblocked(level, text);
    }

    public static void logUnblocked(@NotNull Level level, @NotNull String text) {
        if (level == Level.NOTHING) {
            return;
        }
        InnovativeItems.getInstance().getLogger().log(level.getLogLevel(), text);
    }

    public static void logFunctionError(@NotNull Level level, @NotNull String fieldName, @NotNull String functionName, @NotNull String functionType, @NotNull String abilityName) {
        LogUtil.log(level, "There is not a valid " + fieldName + " entered on the " + functionName + " " + functionType + " on the " + abilityName + " ability!");
    }

    public static void logFunctionError(@NotNull Level level, @NotNull FunctionContext context, @NotNull String fieldName) {
        String functionType = context.getFunction() instanceof Keyword ? "keyword" : (context.getFunction() instanceof Condition ? "condition" : "function");
        LogUtil.logFunctionError(level, fieldName, context.getFunction().getIdentifier(), functionType, context.getAbilityName());
    }

    public static void logFunctionError(@NotNull FunctionContext context, @NotNull String fieldName) {
        LogUtil.logFunctionError(Level.WARNING, context, fieldName);
    }

    public static enum Level {
        NOTHING(null, 0),
        SEVERE(java.util.logging.Level.SEVERE, 1),
        WARNING(java.util.logging.Level.WARNING, 2),
        INFO(java.util.logging.Level.INFO, 3),
        DEV(java.util.logging.Level.INFO, 4),
        NOISE(java.util.logging.Level.INFO, 5);

        private final java.util.logging.Level logLevel;
        private final int debugLevel;

        private Level(java.util.logging.Level logLevel, int debugLevel) {
            this.logLevel = logLevel;
            this.debugLevel = debugLevel;
        }

        @Nullable
        public java.util.logging.Level getLogLevel() {
            return this.logLevel;
        }

        public int getDebugLevel() {
            return this.debugLevel;
        }
    }
}

