/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.IllegalClassException;
import org.jetbrains.annotations.NotNull;

public final class InitializationUtil {
    private InitializationUtil() {
    }

    @NotNull
    public static <T extends Number> T initNumber(@NotNull String text, @NotNull Class<T> clazz) throws IllegalClassException, NumberFormatException {
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return (T)((Number)method.invoke(null, text));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalClassException("Was expecting a class that extends number and was a primitive data type wrapper!");
        }
    }

    public static boolean initBoolean(@NotNull String text) throws IllegalArgumentException {
        if (text.equalsIgnoreCase("true")) {
            return true;
        }
        if (text.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("The string provided: " + text + " cannot be cast to a boolean safely!");
    }

    public static char initChar(@NotNull String text) throws IllegalArgumentException {
        if (text.length() != 1) {
            throw new IllegalArgumentException("The string provided: " + text + " cannot be cast to a char safely!");
        }
        return text.charAt(0);
    }
}

