/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.util;

import de.tr7zw.nbtapi.NBTItem;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurabilityUtil {
    private DurabilityUtil() {
    }

    public static void setDurability(@NotNull ItemStack stack, int amount) {
        int damage;
        if (stack.getType().getMaxDurability() <= 0 || !(stack.getItemMeta() instanceof Damageable)) {
            return;
        }
        if (amount <= 0) {
            stack.setAmount(0);
            return;
        }
        Damageable damageable = (Damageable)stack.getItemMeta();
        CustomItem item = InnovativeItems.getInstance().getItemCache().fromItemStack(stack);
        if (item != null && item.getMaxDurability() <= 0) {
            return;
        }
        if (item != null) {
            double ratio = (double)Math.max(Math.min(item.getMaxDurability(), amount), 1) / (double)item.getMaxDurability();
            int newDurability = (int)((double)stack.getType().getMaxDurability() * ratio);
            damage = stack.getType().getMaxDurability() - newDurability;
        } else {
            damage = stack.getType().getMaxDurability() - Math.max(Math.min(stack.getType().getMaxDurability(), amount), 0);
        }
        damageable.setDamage(damage);
        stack.setItemMeta((ItemMeta)damageable);
        if (item != null) {
            NBTItem nbt = new NBTItem(stack, true);
            nbt.setInteger("innovativeplugin-customitem-durability", Integer.valueOf(Math.min(amount, item.getMaxDurability())));
        }
    }

    @Nullable
    public static Integer getDurability(@NotNull ItemStack stack) {
        int nativeDurability;
        if (stack.getType().getMaxDurability() <= 0 || !(stack.getItemMeta() instanceof Damageable)) {
            return null;
        }
        Damageable damageable = (Damageable)stack.getItemMeta();
        NBTItem nbt = new NBTItem(stack);
        CustomItem item = InnovativeItems.getInstance().getItemCache().fromNBTItem(nbt);
        if (item != null && item.getMaxDurability() <= 0) {
            return null;
        }
        int n = item != null && nbt.hasKey("innovativeplugin-customitem-durability") != false ? nbt.getInteger("innovativeplugin-customitem-durability") : (nativeDurability = item != null && nbt.hasKey("innovativeplugin-customitem-durability") == false ? item.getMaxDurability() : stack.getType().getMaxDurability() - damageable.getDamage());
        if (item != null && (stack.getType().getMaxDurability() - damageable.getDamage()) / stack.getType().getMaxDurability() != nativeDurability / item.getMaxDurability()) {
            double ratio = (double)(stack.getType().getMaxDurability() - damageable.getDamage()) / (double)stack.getType().getMaxDurability();
            int real = (int)((double)item.getMaxDurability() * ratio);
            DurabilityUtil.setDurability(stack, real);
            return real;
        }
        return nativeDurability;
    }
}

