/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base.views;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.boboballoon.innovativeitems.ui.base.InnovativeElement;
import me.boboballoon.innovativeitems.ui.base.InnovativeView;
import org.jetbrains.annotations.NotNull;

public class PageableView
extends InnovativeView {
    private final List<List<InnovativeElement>> pages;
    private int currentPageIndex;
    private final List<Transform> onSetPages;

    public PageableView(@NotNull String title, @NotNull List<List<InnovativeElement>> pages) throws IndexOutOfBoundsException {
        super(title, pages.get(0));
        int size = pages.get(0).size();
        if (!pages.stream().allMatch(collection -> collection.size() == size)) {
            throw new IndexOutOfBoundsException("All elements of pages are not the same size!");
        }
        this.pages = pages.stream().map(ArrayList::new).collect(Collectors.toList());
        this.currentPageIndex = 0;
        this.onSetPages = new ArrayList<Transform>();
    }

    protected final void addOnSetPagesListener(@NotNull Transform listener) {
        this.onSetPages.add(listener);
    }

    public final void setPages(@NotNull List<List<InnovativeElement>> pages) {
        if (pages.size() < 1 || !pages.stream().allMatch(collection -> collection.size() == ((List)pages.get(0)).size())) {
            return;
        }
        this.pages.clear();
        List<List<InnovativeElement>> transformed = pages;
        for (int i = this.onSetPages.size() - 1; i >= 0; --i) {
            Transform transform = this.onSetPages.get(i);
            transformed = transform.transform(transformed);
        }
        this.pages.addAll(transformed);
        this.currentPageIndex = 0;
        this.setElements(this.pages.get(this.currentPageIndex));
    }

    public final int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public final void setCurrentPageIndex(int currentPageIndex) {
        int bounded = Math.max(Math.min(this.pages.size() - 1, currentPageIndex), 0);
        if (bounded == this.currentPageIndex) {
            return;
        }
        this.currentPageIndex = bounded;
        this.setElements(this.pages.get(this.currentPageIndex));
    }

    @FunctionalInterface
    protected static interface Transform {
        @NotNull
        public List<List<InnovativeElement>> transform(@NotNull List<List<InnovativeElement>> var1);
    }
}

