/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.boboballoon.innovativeitems.ui.base.InnovativeElement;
import me.boboballoon.innovativeitems.ui.base.views.PagedBorderedView;
import me.boboballoon.innovativeitems.util.LogUtil;
import me.boboballoon.innovativeitems.util.ResponseUtil;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayView<T>
extends PagedBorderedView {
    private final Collection<T> collection;
    private final Function<T, ItemStack> map;
    private final BiConsumer<Player, T> clickAction;
    private final BiFunction<T, String, Boolean> filter;
    private String filterInput;
    private static final int ROWS = 5;
    private static final List<List<InnovativeElement>> EMPTY = DisplayView.empty();

    public DisplayView(@NotNull String title, @NotNull Collection<T> collection, @NotNull Function<T, ItemStack> map, @NotNull BiConsumer<Player, T> clickAction, @Nullable BiFunction<T, String, Boolean> filter) {
        super(Material.GRAY_STAINED_GLASS_PANE, title, EMPTY);
        this.collection = collection;
        this.map = map;
        this.clickAction = clickAction;
        this.filter = filter;
        this.addOnSetPagesListener(page -> this.buildView());
        if (this.filter == null) {
            this.setPages(EMPTY);
            return;
        }
        this.setBottomLeft(InnovativeElement.build(Material.HOPPER, (player, clickType) -> {
            if (clickType == ClickType.RIGHT) {
                this.filterInput = null;
                this.setPages(EMPTY);
                return;
            }
            player.closeInventory();
            boolean success = ResponseUtil.input("Please enter the filter you would like to apply to the view! Type &r&ccancel&r&f to end the prompt.", player, response -> {
                if (response == null) {
                    this.open((Player)player);
                    return;
                }
                this.filterInput = response;
                this.setPages(EMPTY);
                this.open((Player)player);
            });
            if (!success) {
                LogUtil.logUnblocked(LogUtil.Level.SEVERE, "An error occurred asking for user input for " + player.getName() + ". Please contact the developer");
                TextUtil.sendMessage((CommandSender)player, "&r&cAn internal error occurred.");
                this.open((Player)player);
            }
        }, stack -> {
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(TextUtil.format(this.filterInput != null ? "&r&fFilter: " + this.filterInput : "&r&fFilter"));
            meta.setLore(Collections.singletonList(TextUtil.format("&r&fRight click to clear the filter")));
            if (this.filterInput != null) {
                meta.addEnchant(Enchantment.IMPALING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                meta.removeEnchant(Enchantment.IMPALING);
            }
            stack.setItemMeta(meta);
        }));
        this.setPages(EMPTY);
    }

    public DisplayView(@NotNull String title, @NotNull Collection<T> collection, @NotNull Function<T, ItemStack> map, @NotNull BiConsumer<Player, T> clickAction) {
        this(title, collection, map, clickAction, null);
    }

    @NotNull
    private List<List<InnovativeElement>> buildView() {
        int pageSize = 21;
        int except = this.filter != null && this.filterInput != null ? (int)this.collection.stream().filter(element -> this.filter.apply(element, this.filterInput) == false).count() : 0;
        int pageCount = Math.max(1, (int)Math.ceil((double)(this.collection.size() - except) / (double)pageSize));
        ArrayList<List<InnovativeElement>> pages = new ArrayList<List<InnovativeElement>>();
        Iterator<T> iterator = this.filter != null && this.filterInput != null ? this.collection.stream().filter(element -> this.filter.apply(element, this.filterInput)).iterator() : this.collection.iterator();
        for (int i = 0; i < pageCount; ++i) {
            ArrayList<InnovativeElement> page = new ArrayList<InnovativeElement>();
            for (int j = 0; j < 45; ++j) {
                int row = j / 9;
                int col = j % 9;
                if (!iterator.hasNext() || row == 0 || row == 4 || col == 0 || col == 8) {
                    page.add(InnovativeElement.EMPTY);
                    continue;
                }
                T element2 = iterator.next();
                page.add(new InnovativeElement(this.map.apply(element2), player -> this.clickAction.accept((Player)player, (Player)element2)));
            }
            pages.add(page);
        }
        return pages;
    }

    @NotNull
    private static List<List<InnovativeElement>> empty() {
        ArrayList<List<InnovativeElement>> pages = new ArrayList<List<InnovativeElement>>(1);
        ArrayList<InnovativeElement> page = new ArrayList<InnovativeElement>();
        for (int i = 0; i < 45; ++i) {
            page.add(InnovativeElement.EMPTY);
        }
        pages.add(page);
        return pages;
    }
}

