/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.boboballoon.innovativeitems.ui.base.InnovativeElement;
import me.boboballoon.innovativeitems.ui.base.InnovativeView;
import me.boboballoon.innovativeitems.ui.base.elements.BlankElement;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BorderedView
extends InnovativeView {
    private final Material border;
    private InnovativeElement topLeft;
    private InnovativeElement topRight;
    private InnovativeElement bottomLeft;
    private InnovativeElement bottomRight;

    public BorderedView(@NotNull Material border, @NotNull String title, @NotNull List<InnovativeElement> elements, @Nullable InnovativeElement topLeft, @Nullable InnovativeElement topRight, @Nullable InnovativeElement bottomLeft, @Nullable InnovativeElement bottomRight) {
        super(title, BorderedView.operation(elements, border, topLeft, topRight, bottomLeft, bottomRight));
        this.border = border;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        this.addSetElementsListener(page -> BorderedView.operation(page, this.border, this.topLeft, this.topRight, this.bottomLeft, this.bottomRight));
    }

    public BorderedView(@NotNull Material border, @NotNull String title, @NotNull List<InnovativeElement> elements) {
        this(border, title, elements, null, null, null, null);
    }

    public final void setTopLeft(@Nullable InnovativeElement topLeft) {
        this.topLeft = topLeft;
        this.setElements(new ArrayList<InnovativeElement>((Collection<InnovativeElement>)this.getElements()));
    }

    public final void setTopRight(@Nullable InnovativeElement topRight) {
        this.topRight = topRight;
        this.setElements(new ArrayList<InnovativeElement>((Collection<InnovativeElement>)this.getElements()));
    }

    public final void setBottomLeft(@Nullable InnovativeElement bottomLeft) {
        this.bottomLeft = bottomLeft;
        this.setElements(new ArrayList<InnovativeElement>((Collection<InnovativeElement>)this.getElements()));
    }

    public final void setBottomRight(@Nullable InnovativeElement bottomRight) {
        this.bottomRight = bottomRight;
        this.setElements(new ArrayList<InnovativeElement>((Collection<InnovativeElement>)this.getElements()));
    }

    @NotNull
    private static List<InnovativeElement> operation(@NotNull List<InnovativeElement> elements, @NotNull Material border, @Nullable InnovativeElement topLeft, @Nullable InnovativeElement topRight, @Nullable InnovativeElement bottomLeft, @Nullable InnovativeElement bottomRight) {
        BlankElement element = new BlankElement(border);
        for (int i = 0; i < elements.size(); ++i) {
            int row = i / 9;
            int col = i % 9;
            if (row == 0 && col == 0 && topLeft != null) {
                elements.set(i, topLeft);
                continue;
            }
            if (row == 0 && col == 8 && topRight != null) {
                elements.set(i, topRight);
                continue;
            }
            if (row == elements.size() / 9 - 1 && col == 0 && bottomLeft != null) {
                elements.set(i, bottomLeft);
                continue;
            }
            if (row == elements.size() / 9 - 1 && col == 8 && bottomRight != null) {
                elements.set(i, bottomRight);
                continue;
            }
            if (row != 0 && row != elements.size() / 9 - 1 && col != 0 && col != 8) continue;
            elements.set(i, element);
        }
        return elements;
    }
}

