/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base.elements;

import java.util.function.Consumer;
import me.boboballoon.innovativeitems.ui.base.elements.SoundElement;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfirmElement
extends SoundElement {
    private static final ItemStack BOTH = ConfirmElement.build(true, true);
    private static final ItemStack BOLD = ConfirmElement.build(true, false);
    private static final ItemStack ITALICS = ConfirmElement.build(false, true);
    private static final ItemStack NONE = ConfirmElement.build(false, false);

    public ConfirmElement(boolean bold, boolean italics, @Nullable Consumer<Player> clickAction) {
        super(bold && italics ? BOTH : (bold ? BOLD : (italics ? ITALICS : NONE)), Sound.BLOCK_NOTE_BLOCK_CHIME, clickAction, null);
    }

    public ConfirmElement(@Nullable Consumer<Player> clickAction) {
        this(false, false, clickAction);
    }

    public ConfirmElement() {
        this((Consumer<Player>)null);
    }

    @NotNull
    private static ItemStack build(boolean bold, boolean italics) {
        ItemStack stack = new ItemStack(Material.GREEN_TERRACOTTA);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(TextUtil.format("&r&a" + (bold ? "&l" : "") + (italics ? "&o" : "") + "Confirm"));
        stack.setItemMeta(meta);
        return stack;
    }
}

