/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.boboballoon.innovativeitems.ui.base.InnovativeElement;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class InnovativeView
implements InventoryHolder {
    private final Inventory inventory;
    private List<InnovativeElement> elements;
    private final List<Consumer<Player>> onOpen;
    private final List<Consumer<List<InnovativeElement>>> onSetElements;

    public InnovativeView(@NotNull String title, @NotNull List<InnovativeElement> elements) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)elements.size(), (String)TextUtil.format(title));
        this.elements = InnovativeView.populate(elements);
        this.onOpen = new ArrayList<Consumer<Player>>();
        this.onSetElements = new ArrayList<Consumer<List<InnovativeElement>>>();
        this.reload();
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final ImmutableList<InnovativeElement> getElements() {
        return ImmutableList.copyOf(this.elements);
    }

    protected final void addOpenListener(@NotNull Consumer<Player> listener) {
        this.onOpen.add(listener);
    }

    protected final void addSetElementsListener(@NotNull Consumer<List<InnovativeElement>> listener) {
        this.onSetElements.add(listener);
    }

    public final void setElements(@NotNull List<InnovativeElement> elements) throws IllegalArgumentException {
        if (this.getSize() != elements.size()) {
            throw new IllegalArgumentException("Invalid elements provided!");
        }
        for (int i = this.onSetElements.size() - 1; i >= 0; --i) {
            this.onSetElements.get(i).accept(elements);
        }
        this.elements = new ArrayList<InnovativeElement>(InnovativeView.populate(elements));
        this.reload();
    }

    @NotNull
    public final InnovativeElement getElement(int index) {
        return this.elements.get(index);
    }

    public final int getSize() {
        return this.inventory.getSize();
    }

    public final void reload() throws IllegalArgumentException {
        if (this.getSize() != this.elements.size()) {
            throw new IllegalArgumentException("Invalid elements provided!");
        }
        for (int i = 0; i < this.getSize(); ++i) {
            InnovativeElement element = this.getElement(i);
            element.getLoadAction().run();
            this.inventory.setItem(i, element.getStack());
        }
        this.inventory.getViewers().stream().map(human -> (Player)human).forEach(Player::updateInventory);
    }

    public final void open(@NotNull Player player) {
        this.onOpen.forEach(consumer -> consumer.accept(player));
        player.openInventory(this.inventory);
        this.reload();
    }

    @NotNull
    private static List<InnovativeElement> populate(@NotNull List<InnovativeElement> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            InnovativeElement element = elements.get(i);
            if (element != null) continue;
            elements.set(i, InnovativeElement.EMPTY);
        }
        return elements;
    }
}

