/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.ui.base;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InnovativeElement {
    private final ItemStack stack;
    private final BiConsumer<Player, ClickType> clickAction;
    private final Runnable loadAction;
    public static final InnovativeElement EMPTY = new InnovativeElement(new ItemStack(Material.AIR));

    public InnovativeElement(@NotNull ItemStack stack, @Nullable BiConsumer<Player, ClickType> clickAction, @Nullable Runnable loadAction) {
        this.stack = stack;
        this.clickAction = clickAction != null ? clickAction : (player, click) -> {};
        this.loadAction = loadAction != null ? loadAction : () -> {};
    }

    public InnovativeElement(@NotNull ItemStack stack, @Nullable Consumer<Player> clickAction, @Nullable Runnable loadAction) {
        this(stack, clickAction != null ? (player, click) -> clickAction.accept((Player)player) : null, loadAction);
    }

    public InnovativeElement(@NotNull ItemStack stack, @Nullable Consumer<Player> clickAction) {
        this(stack, clickAction, null);
    }

    public InnovativeElement(@NotNull ItemStack stack, @Nullable Runnable loadAction) {
        this(stack, (BiConsumer<Player, ClickType>)null, loadAction);
    }

    public InnovativeElement(@NotNull ItemStack stack) {
        this(stack, (BiConsumer<Player, ClickType>)null, null);
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final BiConsumer<Player, ClickType> getClickAction() {
        return this.clickAction;
    }

    @NotNull
    public final Runnable getLoadAction() {
        return this.loadAction;
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore, boolean glowing, @Nullable BiConsumer<Player, ClickType> clickAction, @Nullable Consumer<ItemStack> loadAction) {
        ItemStack stack = new ItemStack(type);
        ItemMeta meta = stack.getItemMeta();
        if (display != null) {
            meta.setDisplayName(TextUtil.format(display));
        }
        if (lore != null && !lore.isEmpty()) {
            meta.setLore(lore.stream().map(TextUtil::format).collect(Collectors.toList()));
        }
        if (glowing) {
            meta.addEnchant(Enchantment.IMPALING, 1, true);
            meta.addItemFlags(ItemFlag.values());
        }
        stack.setItemMeta(meta);
        return new InnovativeElement(stack, clickAction, loadAction != null ? () -> loadAction.accept(stack) : null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore, boolean glowing, @Nullable BiConsumer<Player, ClickType> clickAction) {
        return InnovativeElement.build(type, display, lore, glowing, clickAction, null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore, boolean glowing, @Nullable Consumer<ItemStack> loadAction) {
        return InnovativeElement.build(type, display, lore, glowing, null, loadAction);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore, boolean glowing) {
        return InnovativeElement.build(type, display, lore, glowing, null, null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore) {
        return InnovativeElement.build(type, display, lore, false, null, null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable List<String> lore, @Nullable BiConsumer<Player, ClickType> clickAction, @Nullable Consumer<ItemStack> loadAction) {
        return InnovativeElement.build(type, display, lore, false, clickAction, loadAction);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display) {
        return InnovativeElement.build(type, display, null, false, null, null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable BiConsumer<Player, ClickType> clickAction, @Nullable Consumer<ItemStack> loadAction) {
        return InnovativeElement.build(type, display, null, false, clickAction, loadAction);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable BiConsumer<Player, ClickType> clickAction, @Nullable Consumer<ItemStack> loadAction) {
        return InnovativeElement.build(type, null, null, false, clickAction, loadAction);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable BiConsumer<Player, ClickType> clickAction) {
        return InnovativeElement.build(type, display, null, false, clickAction, null);
    }

    @NotNull
    public static InnovativeElement build(@NotNull Material type, @Nullable String display, @Nullable Consumer<ItemStack> loadAction) {
        return InnovativeElement.build(type, display, null, false, null, loadAction);
    }
}

