/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import java.util.Map;
import me.boboballoon.innovativeitems.items.ability.Ability;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomItem {
    private final String identifier;
    private final Ability ability;
    private final ItemStack item;
    private final boolean placeable;
    private final boolean soulbound;
    private final boolean wearable;
    private final int maxDurability;
    private final boolean updateItem;
    private final ImmutableList<Recipe> recipes;

    public CustomItem(@NotNull String identifier, @Nullable Ability ability, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, boolean unbreakable, boolean placeable, boolean soulbound, boolean wearable, int maxDurability, boolean updateItem, @Nullable ImmutableList<Recipe> recipes) {
        this(identifier, ability, CustomItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, unbreakable, material.getMaxDurability() != 0 && maxDurability > 0 ? maxDurability : (material.getMaxDurability() != 0 ? (int)material.getMaxDurability() : 0)), placeable, soulbound, wearable, maxDurability, updateItem, recipes);
    }

    public CustomItem(@NotNull String identifier, @Nullable Ability ability, @NotNull ItemStack item, boolean placeable, boolean soulbound, boolean wearable, int maxDurability, boolean updateItem, @Nullable ImmutableList<Recipe> recipes) {
        this.identifier = identifier;
        this.ability = ability;
        this.item = item;
        this.placeable = placeable;
        this.soulbound = soulbound;
        this.wearable = wearable;
        this.maxDurability = item.getType().getMaxDurability() != 0 && maxDurability > 0 ? maxDurability : (item.getType().getMaxDurability() != 0 ? (int)item.getType().getMaxDurability() : 0);
        this.updateItem = updateItem;
        this.recipes = recipes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public Ability getAbility() {
        return this.ability;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public boolean isPlaceable() {
        return this.placeable;
    }

    public boolean isSoulbound() {
        return this.soulbound;
    }

    public boolean isWearable() {
        return this.wearable;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public boolean shouldUpdateItem() {
        return this.updateItem;
    }

    @Nullable
    public ImmutableList<Recipe> getRecipes() {
        return this.recipes;
    }

    public static ItemStack generateItem(@NotNull String identifier, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, boolean unbreakable, int durability) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        } else {
            meta.setDisplayName(identifier);
        }
        if (lore != null) {
            meta.setLore(lore);
        }
        if (enchantments != null) {
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
            }
        }
        if (flags != null) {
            for (ItemFlag flag : flags) {
                meta.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if (attributes != null) {
            meta.setAttributeModifiers(attributes);
        }
        if (customModelData != null) {
            meta.setCustomModelData(customModelData);
        }
        if (unbreakable) {
            meta.setUnbreakable(true);
        }
        item.setItemMeta(meta);
        NBTItem nbtItem = new NBTItem(item, true);
        nbtItem.setBoolean("innovativeplugin-customitem", Boolean.valueOf(true));
        nbtItem.setString("innovativeplugin-customitem-id", identifier);
        nbtItem.setInteger("innovativeplugin-customitem-durability", Integer.valueOf(durability));
        return item;
    }
}

