/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability.trigger.builtin.timer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.ability.trigger.builtin.timer.TimerTrigger;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class AbilityTimerClock
extends BukkitRunnable {
    private final Set<Ability> abilities;

    public AbilityTimerClock(long timer, @NotNull Set<Ability> abilities) {
        this.abilities = abilities;
        this.runTaskTimerAsynchronously((Plugin)InnovativeItems.getInstance(), 0L, timer);
    }

    public AbilityTimerClock(long timer, Ability ... abilities) {
        this(timer, Sets.newHashSet((Object[])abilities));
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerInventory inventory = player.getInventory();
            ItemStack[] items = new ItemStack[6];
            for (int i = 0; i < 4; ++i) {
                items[i] = inventory.getArmorContents()[i];
            }
            items[4] = inventory.getItemInMainHand();
            items[5] = inventory.getItemInOffHand();
            for (ItemStack itemStack : items) {
                Ability ability;
                CustomItem item = InnovativeItems.getInstance().getItemCache().fromItemStack(itemStack);
                if (item == null || (ability = item.getAbility()) == null || !this.abilities.contains(ability) || !(ability.getTrigger() instanceof TimerTrigger)) continue;
                ability.execute(player);
            }
        }
    }

    @NotNull
    public ImmutableSet<Ability> getAbilities() {
        return ImmutableSet.copyOf(this.abilities);
    }

    public void addAbility(@NotNull Ability ability) {
        if (this.abilities.contains(ability)) {
            return;
        }
        this.abilities.add(ability);
    }
}

