/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability.trigger.builtin.projectile;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.ability.trigger.builtin.projectile.ArrowHitBlockTrigger;
import me.boboballoon.innovativeitems.items.ability.trigger.builtin.projectile.ArrowHitEntityTrigger;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrowFireListener
implements Listener {
    private static final Map<UUID, CustomItem> PROJECTILES = new HashMap<UUID, CustomItem>();

    @EventHandler
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player) || !(event.getEntity() instanceof ThrowableProjectile)) {
            return;
        }
        ThrowableProjectile projectile = (ThrowableProjectile)event.getEntity();
        this.register(event.getEntity().getUniqueId(), projectile.getItem());
    }

    @EventHandler
    private void onEntityShootBow(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        this.register(event.getProjectile().getUniqueId(), event.getBow());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onProjectileHit(ProjectileHitEvent event) {
        if (ArrowFireListener.contains(event.getEntity())) {
            Bukkit.getScheduler().runTaskLater((Plugin)InnovativeItems.getInstance(), () -> PROJECTILES.remove(event.getEntity().getUniqueId()), 1L);
        }
    }

    private void register(@NotNull UUID uuid, @NotNull ItemStack stack) {
        CustomItem item = InnovativeItems.getInstance().getItemCache().fromItemStack(stack);
        if (item == null || item.getAbility() == null || !(item.getAbility().getTrigger() instanceof ArrowHitEntityTrigger) && !(item.getAbility().getTrigger() instanceof ArrowHitBlockTrigger)) {
            return;
        }
        PROJECTILES.put(uuid, item);
    }

    public static boolean contains(@NotNull Projectile projectile) {
        return PROJECTILES.containsKey(projectile.getUniqueId());
    }

    @Nullable
    public static CustomItem get(@NotNull Projectile projectile) {
        return PROJECTILES.get(projectile.getUniqueId());
    }
}

