/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability.trigger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface InventoryIterator<T extends Event> {
    @NotNull
    public Iterable<CustomItem> getItems(@NotNull T var1, @NotNull Player var2);

    @NotNull
    public static <T extends Event> InventoryIterator<T> fromFunction(@NotNull BiFunction<T, PlayerInventory, Collection<ItemStack>> function) {
        return (event, player) -> {
            Collection raw = (Collection)function.apply(event, player.getInventory());
            return InnovativeItems.getInstance().getItemCache().fromItemStacks(raw);
        };
    }

    @NotNull
    public static <T extends Event> InventoryIterator<T> fromFunctionSingleton(@NotNull BiFunction<T, PlayerInventory, ItemStack> function) {
        return InventoryIterator.fromFunction((event, inventory) -> Collections.singleton(function.apply((Object)event, (PlayerInventory)inventory)));
    }

    public static final class Constants {
        private static final InventoryIterator<?> ARMOR = InventoryIterator.fromFunction((event, inventory) -> Arrays.asList(inventory.getArmorContents()));
        private static final InventoryIterator<?> MAIN_HAND = InventoryIterator.fromFunctionSingleton((event, inventory) -> inventory.getItemInMainHand());
        private static final InventoryIterator<?> BOTH_HANDS = InventoryIterator.fromFunction((event, inventory) -> Arrays.asList(inventory.getItemInMainHand(), inventory.getItemInOffHand()));
        private static final InventoryIterator<?> ARMOR_AND_HANDS = InventoryIterator.fromFunction((event, inventory) -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Collections.addAll(items, inventory.getArmorContents());
            items.add(inventory.getItemInMainHand());
            items.add(inventory.getItemInOffHand());
            return items;
        });

        private Constants() {
        }

        @NotNull
        public static <T extends Event> InventoryIterator<T> armor() {
            return ARMOR;
        }

        @NotNull
        public static <T extends Event> InventoryIterator<T> mainHand() {
            return MAIN_HAND;
        }

        @NotNull
        public static <T extends Event> InventoryIterator<T> bothHands() {
            return BOTH_HANDS;
        }

        @NotNull
        public static <T extends Event> InventoryIterator<T> armorAndHands() {
            return ARMOR_AND_HANDS;
        }
    }
}

