/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability.trigger;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.function.Predicate;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.ability.trigger.InventoryIterator;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityTrigger<T extends Event, S extends RuntimeContext>
implements Listener {
    private final String identifier;
    private final String regex;
    private final Class<T> eventClass;
    private final Class<S> contextClass;
    private final InventoryIterator<T> iterator;
    private final Predicate<T> predicate;
    private final ImmutableSet<FunctionTargeter> targeters;

    private AbilityTrigger(@NotNull String identifier, @Nullable String regex, @NotNull Class<T> eventClass, @NotNull Class<S> contextClass, @NotNull InventoryIterator<T> iterator, @Nullable Predicate<T> predicate, @NotNull ImmutableSet<FunctionTargeter> targeters) {
        this.identifier = identifier;
        this.regex = regex != null ? regex : identifier;
        this.eventClass = eventClass;
        this.contextClass = contextClass;
        this.iterator = iterator;
        this.predicate = predicate != null ? predicate : event -> true;
        this.targeters = targeters;
    }

    public AbilityTrigger(@NotNull String identifier, @Nullable String regex, @NotNull Class<T> eventClass, @NotNull Class<S> contextClass, @NotNull InventoryIterator<T> iterator, @Nullable Predicate<T> predicate, @NotNull Collection<FunctionTargeter> targeters) {
        this(identifier, regex, eventClass, contextClass, iterator, predicate, AbilityTrigger.toSet(targeters));
    }

    public AbilityTrigger(@NotNull String identifier, @Nullable String regex, @NotNull Class<T> eventClass, @NotNull Class<S> contextClass, @NotNull InventoryIterator<T> iterator, @Nullable Predicate<T> predicate, FunctionTargeter ... targeters) {
        this(identifier, regex, eventClass, contextClass, iterator, predicate, Sets.newHashSet((Object[])targeters));
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final String getRegex() {
        return this.regex;
    }

    @NotNull
    public final Class<T> getEventClass() {
        return this.eventClass;
    }

    @NotNull
    public final Class<S> getContextClass() {
        return this.contextClass;
    }

    @NotNull
    public final InventoryIterator<T> getIterator() {
        return this.iterator;
    }

    @NotNull
    public final Predicate<T> getPredicate() {
        return this.predicate;
    }

    @NotNull
    public final ImmutableSet<FunctionTargeter> getTargeters() {
        return this.targeters;
    }

    @NotNull
    public abstract Player fromEvent(@NotNull T var1);

    @Nullable
    public abstract S trigger(@NotNull T var1, @NotNull CustomItem var2, @NotNull Ability var3);

    public void init(@NotNull Ability ability) {
    }

    @NotNull
    private static ImmutableSet<FunctionTargeter> toSet(@NotNull Collection<FunctionTargeter> targeters) {
        if (!targeters.contains((Object)FunctionTargeter.PLAYER)) {
            targeters.add(FunctionTargeter.PLAYER);
        }
        return ImmutableSet.copyOf(targeters);
    }

    public static boolean isCompatible(@NotNull AbilityTrigger<?, ?> origin, @NotNull AbilityTrigger<?, ?> target) {
        for (FunctionTargeter targeter : target.getTargeters()) {
            if (origin.getTargeters().contains((Object)targeter)) continue;
            return false;
        }
        return true;
    }
}

