/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.boboballoon.innovativeitems.functions.condition.ActiveCondition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.keyword.ActiveKeyword;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.ability.trigger.AbilityTrigger;
import me.boboballoon.innovativeitems.util.TextUtil;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityCooldown
extends Ability {
    private final long cooldown;
    private final CooldownMessage message;
    private final Map<UUID, Long> onCooldown;

    public AbilityCooldown(@NotNull String identifier, @NotNull ImmutableList<ActiveKeyword> keywords, @NotNull ImmutableList<ActiveCondition> conditions, @NotNull AbilityTrigger<?, ?> trigger, @NotNull String providedTriggerIdentifier, long cooldown, @Nullable CooldownMessage message) {
        super(identifier, keywords, conditions, trigger, providedTriggerIdentifier);
        if (cooldown <= 0L) {
            throw new IllegalArgumentException("The provided cooldown is less than or equal to zero!");
        }
        this.cooldown = cooldown * 50L;
        this.message = message;
        this.onCooldown = new HashMap<UUID, Long>();
    }

    public long getCooldown() {
        return this.cooldown;
    }

    @Nullable
    public CooldownMessage getMessage() {
        return this.message;
    }

    public Map<UUID, Long> getOnCooldown() {
        return this.onCooldown;
    }

    public boolean isOnCooldown(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.onCooldown.containsKey(uuid)) {
            return false;
        }
        return this.onCooldown.get(uuid) + this.cooldown > System.currentTimeMillis();
    }

    @Deprecated
    public boolean shouldShowCooldown() {
        return this.message != null;
    }

    @Override
    public boolean execute(@NotNull RuntimeContext context) {
        Player player = context.getPlayer();
        UUID uuid = player.getUniqueId();
        boolean isOnCooldown = this.isOnCooldown(player);
        if (isOnCooldown && this.message != null) {
            this.message.send(player, this.onCooldown.get(uuid), this.cooldown);
            return false;
        }
        if (isOnCooldown) {
            return false;
        }
        boolean result = super.execute(context);
        if (result) {
            this.onCooldown.put(uuid, System.currentTimeMillis());
        }
        return result;
    }

    public static class CooldownMessage {
        private final String message;
        private final ChatMessageType type;

        public CooldownMessage(@NotNull String message, @NotNull ChatMessageType type) {
            this.message = TextUtil.format(message);
            this.type = type;
        }

        public void send(Player player, long waitTime, long cooldown) {
            long millis = waitTime + cooldown - System.currentTimeMillis();
            String cooldownText = String.format("%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) % 60L);
            BaseComponent[] message = TextComponent.fromLegacyText((String)this.message.replace("{cooldown}", cooldownText));
            player.spigot().sendMessage(this.type, message);
        }
    }
}

